/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.appschema.filter.FilterFactoryImplReportInvalidProperty;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.MultipleValue;

public final class SolrMultipleValue
implements MultipleValue {
    private Expression expression;
    private final FilterFactory filterFactory = new FilterFactoryImplReportInvalidProperty();

    public void setExpression(String expression) {
        try {
            this.expression = AppSchemaDataAccessConfigurator.parseOgcCqlExpression((String)expression, (FilterFactory)this.filterFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error parsing target value expression '%s'.", expression), exception);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getId() {
        return UUID.randomUUID().toString();
    }

    public void setFeatureTypeMapping(FeatureTypeMapping featureTypeMapping) {
    }

    public void setAttributeMapping(AttributeMapping attributeMapping) {
    }

    public List<Object> getValues(Feature feature, AttributeMapping attributeMapping) {
        Object value = this.expression.evaluate((Object)feature);
        if (!(value instanceof String)) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String[] parts = ((String)value).split(";");
        values.addAll(Arrays.asList(parts));
        return values;
    }

    public Object evaluate(Object object) {
        return this.expression.evaluate(object);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        return (T)this.expression.evaluate(object, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return this.expression.accept(visitor, extraData);
    }
}

