/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;

public class SolrFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private Iterator<SolrDocument> solrDocIterator;
    private SimpleFeatureType featureType;
    private Boolean next;
    private SimpleFeatureBuilder builder;
    private SolrAttribute pkey;
    private HttpSolrClient server;
    private SolrDataStore solrDataStore;
    private String cursorMark;
    private String nextCursorMark;
    private SolrQuery solrQuery;
    private long counter;
    private Map<Name, SolrSpatialStrategy> geometryReaders;

    public SolrFeatureReader(SimpleFeatureType featureType, HttpSolrClient server, SolrQuery solrQuery, SolrDataStore solrDataStore) throws SolrServerException, IOException {
        this.featureType = featureType;
        this.solrQuery = solrQuery;
        this.solrDataStore = solrDataStore;
        this.pkey = solrDataStore.getPrimaryKey(featureType.getTypeName());
        this.builder = new SimpleFeatureBuilder(featureType);
        this.server = server;
        if (solrQuery.getFields() != null && !solrQuery.getFields().contains(this.pkey.getName())) {
            solrQuery.addField(this.pkey.getName());
        }
        this.cursorMark = solrQuery.getStart() != null && solrQuery.getStart() > 0 ? this.getCursorMarkForStart(server, solrQuery) : "*";
        solrQuery.set("cursorMark", new String[]{this.cursorMark});
        QueryResponse rsp = server.query((SolrParams)solrQuery);
        if (this.solrDataStore.getLogger().isLoggable(Level.FINE)) {
            this.solrDataStore.getLogger().log(Level.FINE, "SOLR query done: " + solrQuery.toString());
        }
        this.solrDocIterator = rsp.getResults().iterator();
        this.nextCursorMark = rsp.getNextCursorMark();
        this.counter = 0L;
        this.geometryReaders = new HashMap<Name, SolrSpatialStrategy>();
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            if (!(att instanceof GeometryDescriptor)) continue;
            SolrSpatialStrategy spatialStrategy = SolrSpatialStrategy.createStrategy((GeometryDescriptor)att);
            this.geometryReaders.put(att.getName(), spatialStrategy);
        }
    }

    private String getCursorMarkForStart(HttpSolrClient server, SolrQuery solrQuery) throws SolrServerException, IOException {
        Integer prevRows = solrQuery.getRows();
        solrQuery.setRows(solrQuery.getStart());
        solrQuery.setStart(Integer.valueOf(0));
        solrQuery.set("cursorMark", new String[]{"*"});
        QueryResponse rsp = server.query((SolrParams)solrQuery);
        if (this.solrDataStore.getLogger().isLoggable(Level.FINE)) {
            this.solrDataStore.getLogger().log(Level.FINE, "SOLR query done: " + solrQuery.toString());
        }
        String nextC = rsp.getNextCursorMark();
        solrQuery.setRows(prevRows);
        return nextC;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        Object fid = "";
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more features in this reader, you should call hasNext() to check for feature availability");
            }
            SolrDocument doc = this.solrDocIterator.next();
            fid = this.featureType.getTypeName() + "." + doc.getFieldValue(this.pkey.getName());
            int attributeCount = this.featureType.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                AttributeDescriptor type = this.featureType.getDescriptor(i);
                Object value = doc.getFieldValue(type.getLocalName());
                if (value instanceof List) {
                    value = StringUtils.join((Object[])((List)value).toArray(), (String)";");
                }
                if (type instanceof GeometryDescriptor) {
                    Geometry geometry;
                    GeometryDescriptor gatt = (GeometryDescriptor)type;
                    if (value == null) continue;
                    SolrSpatialStrategy spatialStrategy = this.geometryReaders.get(gatt.getName());
                    if (spatialStrategy == null) {
                        spatialStrategy = SolrSpatialStrategy.DEFAULT;
                    }
                    if ((geometry = spatialStrategy.decode(value.toString())) != null && geometry.getUserData() == null) {
                        geometry.setUserData((Object)gatt.getCoordinateReferenceSystem());
                    }
                    this.builder.add((Object)geometry);
                    continue;
                }
                this.builder.add(value);
            }
            SimpleFeature simpleFeature = this.builder.buildFeature((String)fid);
            return simpleFeature;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.solrDataStore.getLogger().isLoggable(Level.FINE)) {
                this.solrDataStore.getLogger().log(Level.FINE, "Created " + (String)fid);
            }
            this.next = null;
            ++this.counter;
        }
    }

    public boolean hasNext() throws IOException {
        if (this.next == null) {
            if (this.solrDocIterator.hasNext()) {
                this.next = true;
            } else if (this.counter < (long)this.solrQuery.getRows().intValue() && !this.cursorMark.equals(this.nextCursorMark)) {
                this.cursorMark = this.nextCursorMark;
                this.solrQuery.set("cursorMark", new String[]{this.cursorMark});
                try {
                    QueryResponse rsp = this.server.query((SolrParams)this.solrQuery);
                    if (this.solrDataStore.getLogger().isLoggable(Level.FINE)) {
                        this.solrDataStore.getLogger().log(Level.FINE, this.server.getBaseURL() + "/select?" + this.solrQuery.toString());
                    }
                    this.solrDocIterator = rsp.getResults().iterator();
                    this.nextCursorMark = rsp.getNextCursorMark();
                    this.next = this.solrDocIterator.hasNext();
                }
                catch (SolrServerException e) {
                    this.solrDataStore.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    this.next = false;
                }
            } else {
                this.next = false;
            }
        }
        return this.next;
    }

    public void close() throws IOException {
    }
}

