/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.solr.SolrLayerMapper;
import org.geotools.util.logging.Logging;

public class SingleLayerMapper
implements SolrLayerMapper {
    static final Logger LOGGER = Logging.getLogger(SingleLayerMapper.class);

    @Override
    public List<String> createTypeNames(HttpSolrClient solr) throws Exception {
        try {
            String last;
            String[] path;
            URL url = new URL(solr.getBaseURL());
            String[] stringArray = path = url.getPath() != null ? url.getPath().split("/") : null;
            if (path != null && path.length > 0 && !(last = path[path.length - 1]).trim().isEmpty()) {
                return Arrays.asList(last);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINE, "unable to parse solr url: " + solr.getBaseURL(), e);
        }
        return Arrays.asList("index");
    }

    @Override
    public String prepareFilterQueryForSchema() {
        return null;
    }

    @Override
    public String prepareFilterQuery(SimpleFeatureType featureType) {
        return null;
    }
}

