/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class IndexesConfig {
    private final ConcurrentHashMap<String, IndexConfig> indexesConfig = new ConcurrentHashMap();
    private final List<String> indexesNames = new ArrayList<String>();

    public void addGeometry(String indexName, String attributeName, String srid, String type, String isDefault) {
        GeometryConfig geometry = GeometryConfig.create(attributeName, srid, type, isDefault);
        this.getIndexConfig(indexName).addGeometry(geometry);
    }

    public void addAttributes(String indexName, Collection<String> attributes) {
        IndexConfig indexConfig = this.getIndexConfig(indexName);
        indexConfig.getAttributes().addAll(attributes);
    }

    public SimpleFeatureType buildFeatureType(String indexName, List<SolrAttribute> solrAttributes) {
        return this.getIndexConfig(indexName).buildFeatureType(solrAttributes);
    }

    public List<String> getIndexesNames() {
        return this.indexesNames;
    }

    public IndexConfig getIndexConfig(String indexName) {
        IndexConfig indexConfig = this.indexesConfig.get(indexName);
        if (indexConfig == null) {
            indexConfig = new IndexConfig(indexName);
            IndexConfig existing = this.indexesConfig.putIfAbsent(indexName, indexConfig);
            if (existing == null) {
                this.indexesNames.add(indexName);
            } else {
                indexConfig = existing;
            }
        }
        return indexConfig;
    }

    private static final class GeometryConfig {
        private final String attributeName;
        private final CoordinateReferenceSystem crs;
        private final Class<? extends Geometry> type;
        private final boolean isDefault;

        GeometryConfig(String attributeName, CoordinateReferenceSystem crs, Class<? extends Geometry> type, boolean isDefault) {
            this.attributeName = attributeName;
            this.crs = crs;
            this.type = type;
            this.isDefault = isDefault;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public CoordinateReferenceSystem getCrs() {
            return this.crs;
        }

        public Class<? extends Geometry> getType() {
            return this.type;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        private static GeometryConfig create(String attributeName, String srid, String type, String isDefault) {
            CoordinateReferenceSystem crs;
            try {
                crs = CRS.decode((String)("EPSG:" + srid));
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Error decoding CRS 'EPSG:%s'.", srid), exception);
            }
            return new GeometryConfig(attributeName, crs, GeometryConfig.matchGeometryType(type), Boolean.parseBoolean(isDefault));
        }

        private static Class<? extends Geometry> matchGeometryType(String geometryTypeName) {
            switch (geometryTypeName) {
                case "POINT": {
                    return Point.class;
                }
                case "LINESTRING": {
                    return LineString.class;
                }
                case "POLYGON": {
                    return Polygon.class;
                }
                case "MULTIPOINT": {
                    return MultiPoint.class;
                }
                case "MULTILINESTRING": {
                    return MultiLineString.class;
                }
                case "MULTIPOLYGON": {
                    return MultiPolygon.class;
                }
            }
            return Geometry.class;
        }
    }

    public static final class IndexConfig {
        private static final Logger LOGGER = Logging.getLogger(IndexConfig.class);
        private final String indexName;
        private final List<GeometryConfig> geometries = new ArrayList<GeometryConfig>();
        private final List<String> attributes = new ArrayList<String>();
        private Boolean denormalizedIndexMode = false;

        IndexConfig(String indexName) {
            this.indexName = indexName;
        }

        void addGeometry(GeometryConfig geometry) {
            this.geometries.add(geometry);
        }

        List<String> getAttributes() {
            return this.attributes;
        }

        GeometryConfig searchGeometry(String attributeName) {
            return IndexConfig.search(this.geometries, geometry -> Objects.equals(geometry.getAttributeName(), attributeName));
        }

        GeometryConfig searchDefaultGeometry() {
            return IndexConfig.search(this.geometries, GeometryConfig::isDefault);
        }

        SimpleFeatureType buildFeatureType(List<SolrAttribute> solrAttributes) {
            GeometryConfig defaultGeometry;
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName(this.indexName);
            if (!this.denormalizedIndexMode.booleanValue()) {
                for (String attributeName : this.attributes) {
                    AttributeDescriptor attribute = this.buildAttributeDescriptor(attributeName, solrAttributes);
                    if (attribute == null) continue;
                    featureTypeBuilder.add(attribute);
                }
            } else {
                for (SolrAttribute sa : solrAttributes) {
                    AttributeDescriptor attribute = this.buildAttributeDescriptor(sa.getName(), solrAttributes);
                    if (attribute == null) continue;
                    featureTypeBuilder.add(attribute);
                }
            }
            if ((defaultGeometry = this.searchDefaultGeometry()) != null) {
                featureTypeBuilder.setDefaultGeometry(defaultGeometry.getAttributeName());
            }
            return featureTypeBuilder.buildFeatureType();
        }

        private AttributeDescriptor buildAttributeDescriptor(String attributeName, List<SolrAttribute> solrAttributes) {
            SolrAttribute solrAttribute = IndexConfig.searchAttribute(attributeName, solrAttributes);
            if (solrAttribute == null) {
                LOGGER.log(Level.WARNING, String.format("Could not find attribute '%s' in Solar index '%s' schema.", attributeName, this.indexName));
                return null;
            }
            AttributeDescriptor attribute = this.buildAttributeDescriptor(solrAttribute, this.searchGeometry(attributeName));
            attribute.getUserData().put("solr_type", solrAttribute.getSolrType());
            return attribute;
        }

        private AttributeDescriptor buildAttributeDescriptor(SolrAttribute solrAttribute, GeometryConfig geometry) {
            AttributeTypeBuilder attributeBuilder = new AttributeTypeBuilder();
            if (geometry == null) {
                attributeBuilder.setName(solrAttribute.getName());
                attributeBuilder.setBinding(solrAttribute.getType());
                return attributeBuilder.buildDescriptor(solrAttribute.getName(), attributeBuilder.buildType());
            }
            attributeBuilder.setCRS(geometry.getCrs());
            attributeBuilder.setName(geometry.getAttributeName());
            attributeBuilder.setBinding(geometry.getType());
            return attributeBuilder.buildDescriptor(geometry.getAttributeName(), attributeBuilder.buildGeometryType());
        }

        private static SolrAttribute searchAttribute(String attributeName, List<SolrAttribute> solrAttributes) {
            return IndexConfig.search(solrAttributes, solrAttribute -> Objects.equals(solrAttribute.getName(), attributeName));
        }

        private static <T> T search(List<T> objects, Function<T, Boolean> predicate) {
            for (T object : objects) {
                if (!predicate.apply(object).booleanValue()) continue;
                return object;
            }
            return null;
        }

        public Boolean getDenormalizedIndexMode() {
            return this.denormalizedIndexMode;
        }

        public void setDenormalizedIndexMode(Boolean denormalizedIndexMode) {
            this.denormalizedIndexMode = denormalizedIndexMode;
        }
    }
}

