/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.Locale;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.type.GeometryDescriptor;

public abstract class SolrSpatialStrategy {
    static final SolrSpatialStrategy DEFAULT = new DefaultStrategy();
    static final SolrSpatialStrategy BBOX = new BBoxStrategy();

    static SolrSpatialStrategy createStrategy(GeometryDescriptor att) {
        String solrType = (String)att.getUserData().get("solr_type");
        if (solrType != null && solrType.contains("BBoxField")) {
            return BBOX;
        }
        return DEFAULT;
    }

    public abstract String encode(Geometry var1);

    public abstract Geometry decode(String var1) throws ParseException;

    public static class BBoxStrategy
    extends SolrSpatialStrategy {
        @Override
        public String encode(Geometry geometry) {
            Envelope env = geometry.getEnvelopeInternal();
            return String.format(Locale.ENGLISH, "ENVELOPE(%f,%f,%f,%f)", env.getMinX(), env.getMaxX(), env.getMaxY(), env.getMinY());
        }

        @Override
        public Geometry decode(String str) throws ParseException {
            if (str.toUpperCase().startsWith("ENVELOPE")) {
                return this.decodeCql(str);
            }
            return this.decodeBbox(str);
        }

        private Geometry decodeCql(String str) throws ParseException {
            String[] bbox = str.split(",");
            if (bbox.length != 4) {
                throw new ParseException("Illegal bounding box: " + str);
            }
            bbox[0] = bbox[0].substring(bbox[0].indexOf("(") + 1, bbox[0].length());
            bbox[3] = bbox[3].substring(0, bbox[3].indexOf(")"));
            Envelope env = new Envelope(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[3]));
            return JTS.toGeometry((Envelope)env);
        }

        private Geometry decodeBbox(String str) throws ParseException {
            String[] bbox = str.split("\\s+");
            if (bbox.length != 4) {
                throw new ParseException("Illegal bounding box: " + str);
            }
            Envelope env = new Envelope(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[3]));
            return JTS.toGeometry((Envelope)env);
        }
    }

    public static class DefaultStrategy
    extends SolrSpatialStrategy {
        @Override
        public String encode(Geometry geometry) {
            WKTWriter writer = new WKTWriter();
            return writer.write(geometry);
        }

        @Override
        public Geometry decode(String str) throws ParseException {
            return new WKTReader().read(str);
        }
    }
}

