/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrFeatureReader;
import org.geotools.data.solr.SolrLayerConfiguration;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class SolrFeatureSource
extends ContentFeatureSource {
    public static final String KEY_SOLR_TYPE = "solr_type";
    protected SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Map<String, SimpleFeatureType> defaultFeatureTypes;

    public SolrFeatureSource(ContentEntry entry) {
        this(entry, Collections.emptyMap());
    }

    public SolrFeatureSource(ContentEntry entry, Map<String, SimpleFeatureType> defaultFeatureTypes) {
        super(entry, Query.ALL);
        this.defaultFeatureTypes = defaultFeatureTypes;
    }

    public SolrDataStore getDataStore() {
        return (SolrDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.getSchema().getCoordinateReferenceSystem());
        ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)flatCRS);
        SolrDataStore store = this.getDataStore();
        Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        Query preQuery = new Query(query);
        preQuery.setFilter(preFilter);
        SolrQuery q = this.getDataStore().select(this.getSchema(), preQuery);
        if (this.getDataStore().getLogger().isLoggable(Level.FINE)) {
            this.getDataStore().getLogger().log(Level.FINE, q.toString());
        }
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(store, postFilter, q);){
            if (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                bounds.init(f.getBounds());
                while (reader.hasNext()) {
                    f = (SimpleFeature)reader.next();
                    bounds.include(f.getBounds());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bounds;
    }

    private FeatureReader<SimpleFeatureType, SimpleFeature> getReader(SolrDataStore store, Filter postFilter, SolrQuery q) throws SolrServerException, IOException {
        SolrFeatureReader reader = new SolrFeatureReader(this.getSchema(), store.getSolrServer(), q, this.getDataStore());
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            reader = new FilteringFeatureReader((FeatureReader)reader, postFilter);
        }
        return reader;
    }

    protected int getCountInternal(Query query) throws IOException {
        int count = 0;
        try {
            SolrDataStore store = this.getDataStore();
            Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
            Filter preFilter = split[0];
            Filter postFilter = split[1];
            if (postFilter != null && postFilter != Filter.INCLUDE) {
                try (FeatureReader reader = this.getReader(query);){
                    while (reader.hasNext()) {
                        reader.next();
                        ++count;
                    }
                }
                return count;
            }
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            SolrQuery q = store.count(this.getSchema(), preQuery);
            if (store.getLogger().isLoggable(Level.FINE)) {
                store.getLogger().log(Level.FINE, q.toString());
            }
            HttpSolrClient server = store.getSolrServer();
            QueryResponse rsp = server.query((SolrParams)q);
            count = (int)(rsp.getResults().getNumFound() - rsp.getResults().getStart());
            if (query.getMaxFeatures() > 0 && query.getMaxFeatures() < Integer.MAX_VALUE && count > query.getMaxFeatures()) {
                count = query.getMaxFeatures();
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        return count;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        SolrFeatureReader reader;
        try {
            SolrDataStore store = this.getDataStore();
            Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
            Filter preFilter = split[0];
            Filter postFilter = split[1];
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            SimpleFeatureType[] types = this.buildQueryAndReturnFeatureTypes(this.getSchema(), query.getPropertyNames(), postFilter);
            SimpleFeatureType querySchema = types[0];
            SimpleFeatureType returnedSchema = types[1];
            SolrQuery q = store.select(querySchema, preQuery);
            if (store.getLogger().isLoggable(Level.FINE)) {
                store.getLogger().log(Level.FINE, q.toString());
            }
            reader = new SolrFeatureReader(querySchema, store.getSolrServer(), q, store);
            if (postFilter != null && postFilter != Filter.INCLUDE) {
                reader = new FilteringFeatureReader((FeatureReader)reader, postFilter);
                if (!returnedSchema.equals(querySchema)) {
                    reader = new ReTypeFeatureReader((FeatureReader)reader, returnedSchema);
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        return reader;
    }

    protected List<String> getUniqueScalarList(Query query, UniqueVisitor visitor) throws IOException {
        List<String> values;
        try {
            SolrDataStore store = this.getDataStore();
            Filter[] split = this.splitFilter(query.getFilter(), (FeatureSource)this);
            Filter preFilter = split[0];
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            preQuery.setStartIndex(Integer.valueOf(visitor.getStartIndex()));
            preQuery.setMaxFeatures(visitor.getMaxFeatures());
            HttpSolrClient solrServer = store.getSolrServer();
            SolrQuery q = store.selectUniqueValues(this.getSchema(), preQuery, visitor);
            QueryResponse rsp = solrServer.query((SolrParams)q);
            values = rsp.getGroupResponse().getValues().stream().filter(g -> g.getName().equals(visitor.getExpression().toString())).flatMap(gr -> gr.getValues().stream()).map(g -> g.getGroupValue()).collect(Collectors.toList());
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        return values;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        tb.setName(this.entry.getName());
        SolrLayerConfiguration layerConfiguration = this.getDataStore().getSolrConfigurations().get(this.entry.getTypeName());
        String pkField = null;
        if (layerConfiguration != null) {
            String defaultGeometryName = null;
            for (SolrAttribute attribute : layerConfiguration.getAttributes()) {
                AttributeDescriptor att;
                block12: {
                    if (!attribute.isUse().booleanValue()) continue;
                    att = null;
                    if (attribute.isPk().booleanValue()) {
                        pkField = attribute.getName();
                    }
                    if (Geometry.class.isAssignableFrom(attribute.getType())) {
                        Integer srid = attribute.getSrid();
                        try {
                            if (srid == null) break block12;
                            ab.setCRS(CRS.decode((String)("EPSG:" + srid)));
                            ab.setName(attribute.getName());
                            ab.setBinding(attribute.getType());
                            att = ab.buildDescriptor(attribute.getName(), ab.buildGeometryType());
                            if (attribute.isDefaultGeometry() != null && attribute.isDefaultGeometry().booleanValue()) {
                                defaultGeometryName = attribute.getName();
                            }
                        }
                        catch (Exception e) {
                            String msg = "Error occured determing srid for " + attribute.getName();
                            this.getDataStore().getLogger().log(Level.WARNING, msg, e);
                        }
                    } else {
                        ab.setName(attribute.getName());
                        ab.setBinding(attribute.getType());
                        att = ab.buildDescriptor(attribute.getName(), ab.buildType());
                    }
                }
                if (att == null) continue;
                att.getUserData().put(KEY_SOLR_TYPE, attribute.getSolrType());
                tb.add(att);
            }
            if (defaultGeometryName != null) {
                tb.setDefaultGeometry(defaultGeometryName);
            }
        } else {
            SimpleFeatureType defaultFeatureType = this.defaultFeatureTypes.get(this.entry.getTypeName());
            if (defaultFeatureType != null) {
                return defaultFeatureType;
            }
        }
        SimpleFeatureType ft = tb.buildFeatureType();
        if (pkField != null) {
            ft.getUserData().put("id_field", pkField);
        }
        return ft;
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canOffset() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    public ResourceInfo getInfo() {
        return super.getInfo();
    }

    private SimpleFeatureType[] buildQueryAndReturnFeatureTypes(SimpleFeatureType featureType, String[] propertyNames, Filter filter) {
        SimpleFeatureType returnedSchema;
        SimpleFeatureType[] types = null;
        if (propertyNames == Query.ALL_NAMES) {
            return new SimpleFeatureType[]{featureType, featureType};
        }
        SimpleFeatureType querySchema = returnedSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureType, (String[])propertyNames);
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(featureType);
            filter.accept((FilterVisitor)extractor, null);
            String[] extraAttributes = extractor.getAttributeNames();
            if (extraAttributes != null && extraAttributes.length > 0) {
                ArrayList<String> allAttributes = new ArrayList<String>(Arrays.asList(propertyNames));
                for (String extraAttribute : extraAttributes) {
                    if (allAttributes.contains(extraAttribute)) continue;
                    allAttributes.add(extraAttribute);
                }
                String[] allAttributeArray = allAttributes.toArray(new String[allAttributes.size()]);
                querySchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])allAttributeArray);
            }
        }
        types = new SimpleFeatureType[]{querySchema, returnedSchema};
        return types;
    }

    private Filter[] splitFilter(Filter original, FeatureSource source) {
        Filter[] split = new Filter[2];
        if (original != null) {
            SolrFeatureSource featureSource = (SolrFeatureSource)source;
            PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.getDataStore().getFilterCapabilities(), featureSource.getSchema(), null);
            original.accept((FilterVisitor)splitter, null);
            split[0] = splitter.getFilterPre();
            split[1] = splitter.getFilterPost();
        }
        return split;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        SortByImpl sortBy;
        PropertyName propName;
        List exprs;
        if (visitor instanceof UniqueVisitor) {
            this.handleUniqueVisitor(query, (UniqueVisitor)visitor);
            return true;
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            return false;
        }
        if (visitor instanceof MinVisitor) {
            MinVisitor minVisitor = (MinVisitor)visitor;
            exprs = minVisitor.getExpressions();
            if (exprs.size() != 1 || !(exprs.get(0) instanceof PropertyName)) {
                return false;
            }
            propName = (PropertyName)exprs.get(0);
            sortBy = new SortByImpl(propName, SortOrder.ASCENDING);
        } else if (visitor instanceof MaxVisitor) {
            MaxVisitor maxVisitor = (MaxVisitor)visitor;
            exprs = maxVisitor.getExpressions();
            if (exprs.size() != 1 || !(exprs.get(0) instanceof PropertyName)) {
                return false;
            }
            propName = (PropertyName)exprs.get(0);
            sortBy = new SortByImpl(propName, SortOrder.DESCENDING);
        } else if (visitor instanceof NearestVisitor) {
            NearestVisitor nearestVisitor = (NearestVisitor)visitor;
            Expression exp = nearestVisitor.getExpression();
            if (!(exp instanceof PropertyName)) {
                return false;
            }
            propName = (PropertyName)exp;
            if (!(nearestVisitor.getValueToMatch() instanceof Date)) {
                return false;
            }
            FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
            PropertyName expr = factory.property("abs(ms(" + this.dateFormatUTC.format(nearestVisitor.getValueToMatch()) + "," + propName.getPropertyName() + "))");
            sortBy = new SortByImpl(expr, SortOrder.ASCENDING);
        } else {
            return false;
        }
        Query newQuery = new Query(query);
        newQuery.setSortBy(new SortBy[]{sortBy});
        newQuery.setMaxFeatures(1);
        try (FeatureReader reader = this.getReader(newQuery);){
            while (reader.hasNext()) {
                visitor.visit(reader.next());
            }
        }
        return true;
    }

    private void handleUniqueVisitor(Query query, UniqueVisitor visitor) throws IOException {
        visitor.setValue(this.getUniqueScalarList(query, visitor));
    }
}

