/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.solr.FilterToSolr;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TContains;
import org.opengis.temporal.Period;

public class ExpressionToSolr
implements ExpressionVisitor {
    private static Logger LOGGER = Logging.getLogger(ExpressionToSolr.class);
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private static final double SOLR_DISTANCE_TOLERANCE = 180.0;
    protected SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Filter filter;
    private SimpleFeatureType featureType;
    private SolrSpatialStrategy spatialStrategy;

    public ExpressionToSolr() {
        this.dateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public ExpressionToSolr(Filter filter) {
        this();
        this.filter = filter;
    }

    public void setSpatialStrategy(SolrSpatialStrategy spatialStrategy) {
        this.spatialStrategy = spatialStrategy;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException("Nil expression not supported");
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException("Add expression not supported");
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException("Divide expression not supported");
    }

    public Object visit(Function expression, Object extraData) {
        throw new UnsupportedOperationException("Function expression not supported");
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException("Multiply expression not supported");
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException("Subtract expression not supported");
    }

    public Object visit(Literal expression, Object extraData) {
        StringBuffer temp = new StringBuffer("");
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        Object literal = expression.getValue();
        if (literal instanceof Geometry) {
            this.handle(temp, (Geometry)literal);
        } else if (literal instanceof Envelope) {
            this.handle(temp, (Envelope)literal);
        } else if (literal instanceof Number) {
            temp.append(literal.toString());
        } else if (literal instanceof Date) {
            temp.append("\"" + this.dateFormatUTC.format(literal) + "\"");
        } else if (literal instanceof Period) {
            Period period;
            if (this.filter instanceof After) {
                period = (Period)literal;
                temp.append(this.dateFormatUTC.format(period.getEnding().getPosition().getDate()));
            }
            if (this.filter instanceof Before || this.filter instanceof Begins || this.filter instanceof BegunBy) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getBeginning().getPosition().getDate()) + "\"");
            }
            if (this.filter instanceof Ends || this.filter instanceof EndedBy) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getEnding().getPosition().getDate()) + "\"");
            }
            if (this.filter instanceof During || this.filter instanceof TContains) {
                period = (Period)literal;
                temp.append("\"" + this.dateFormatUTC.format(period.getBeginning().getPosition().getDate()) + "\"");
                temp.append(" TO ");
                temp.append("\"" + this.dateFormatUTC.format(period.getEnding().getPosition().getDate()) + "\"");
            }
        } else {
            Object escaped = FilterToSolr.escapeSpecialCharacters(literal.toString(), new String[0]);
            escaped = "\"" + (String)escaped + "\"";
            temp.append((String)escaped);
        }
        output.append(temp);
        return temp;
    }

    private void handle(StringBuffer buff, Envelope envelope) {
        this.handle(buff, (Geometry)JTS.toGeometry((Envelope)envelope));
    }

    private void handle(StringBuffer buff, Geometry geometry) {
        Envelope env;
        if (this.spatialStrategy == null) {
            throw new IllegalStateException("Attempt to encode geometry literal but spatialStrategy is null");
        }
        if (!WORLD.contains(geometry.getEnvelopeInternal()) && !WORLD.equals((Object)geometry.getEnvelopeInternal())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SOLR cannot deal with filters using geometries that span beyond the whole world, clip feature geometry to world");
            }
            geometry = geometry.intersection((Geometry)JTS.toGeometry((Envelope)WORLD));
        }
        if ((env = geometry.getEnvelopeInternal()).getWidth() > 180.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Split segment exceeds the 180 degree longitude limit to conform to SOLR WKT manager specification");
            }
            Densifier densifier = new Densifier(geometry);
            densifier.setDistanceTolerance(180.0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Original geometry: " + geometry.toText());
            }
            geometry = densifier.getResultGeometry();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Densified geometry: " + geometry.toText());
            }
        }
        buff.append(this.spatialStrategy.encode(geometry));
    }

    public Object visit(PropertyName expression, Object extraData) {
        StringBuffer temp = new StringBuffer("");
        StringWriter output = FilterToSolr.asStringWriter(extraData);
        temp.append(this.encodePropertyName(expression));
        output.append(temp);
        return temp;
    }

    private String encodePropertyName(PropertyName expression) {
        if (expression == null) {
            LOGGER.log(Level.WARNING, "NULL property name provided.");
            return null;
        }
        if (this.featureType == null) {
            return this.getPropertyName(expression);
        }
        AttributeDescriptor attribute = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
        if (attribute == null) {
            return this.getPropertyName(expression);
        }
        return attribute.getLocalName();
    }

    private String getPropertyName(PropertyName expression) {
        String name = expression.getPropertyName();
        if (name == null) {
            LOGGER.log(Level.WARNING, "Property name with NULL name provided.");
            return null;
        }
        return name;
    }
}

