/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TestsSolrUtils {
    public static HttpSolrClient instantiateClient(String baseUrl) {
        HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(baseUrl).allowCompression(true).withConnectionTimeout(5000)).withSocketTimeout(5000)).build();
        client.setFollowRedirects(true);
        return client;
    }

    public static void runUpdateRequest(HttpSolrClient client, InputStream xml) {
        UpdateRequest request = new UpdateRequest();
        List<SolrInputDocument> documents = TestsSolrUtils.parseDocuments(xml);
        request.add(documents);
        TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)request).throwIfNeeded();
    }

    public static void createWktFieldType(HttpSolrClient client) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "wkt");
        attributes.put("class", "solr.SpatialRecursivePrefixTreeFieldType");
        attributes.put("spatialContextFactory", "org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory");
        TestsSolrUtils.createFieldType(client, attributes);
    }

    public static void createBboxFieldType(HttpSolrClient client) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "bbox");
        attributes.put("class", "solr.BBoxField");
        attributes.put("numberType", "double");
        attributes.put("geo", "true");
        TestsSolrUtils.createFieldType(client, attributes);
    }

    public static void createWktField(HttpSolrClient client, String name) {
        TestsSolrUtils.createField(client, name, "wkt");
    }

    public static void createBboxField(HttpSolrClient client, String name) {
        TestsSolrUtils.createField(client, name, "bbox");
    }

    static InputStream resourceToStream(String resourceAbsolutePath) {
        InputStream input = TestsSolrUtils.class.getResourceAsStream(resourceAbsolutePath);
        if (input == null) {
            throw new RuntimeException(String.format("Could not find resource '%s'.", resourceAbsolutePath));
        }
        return input;
    }

    public static void createFieldType(HttpSolrClient client, Map<String, Object> attributes) {
        FieldTypeDefinition typeDefinition = new FieldTypeDefinition();
        typeDefinition.setAttributes(attributes);
        Response addResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.AddFieldType(typeDefinition));
        if (!addResponse.hasErrors()) {
            return;
        }
        Response replaceResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.ReplaceFieldType(typeDefinition));
        if (replaceResponse.hasErrors()) {
            Response.throwIfNeeded(addResponse, replaceResponse);
        }
    }

    public static void createField(HttpSolrClient client, String name, String type) {
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", name);
        field.put("type", type);
        Response addResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.AddField(field));
        if (!addResponse.hasErrors()) {
            return;
        }
        Response replaceResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.ReplaceField(field));
        if (replaceResponse.hasErrors()) {
            Response.throwIfNeeded(addResponse, replaceResponse);
        }
    }

    private static Response runSolrRequest(HttpSolrClient client, SolrRequest<? extends SolrResponseBase> request) {
        try {
            Response response = Response.parse((SolrResponseBase)request.process((SolrClient)client));
            if (response.hasErrors()) {
                return response;
            }
            client.commit();
            return response;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error executing Solr request.", exception);
        }
    }

    private static List<SolrInputDocument> parseDocuments(InputStream xml) {
        ArrayList<SolrInputDocument> solrDocuments = new ArrayList<SolrInputDocument>();
        Document document = TestsSolrUtils.parseXmlDocument(xml);
        NodeList documentsNodes = document.getElementsByTagName("doc");
        for (int i = 0; i < documentsNodes.getLength(); ++i) {
            Node documentNode = documentsNodes.item(i);
            if (documentNode.getNodeType() != 1) continue;
            SolrInputDocument solrDocument = new SolrInputDocument(new String[0]);
            NodeList fieldsNodes = documentNode.getChildNodes();
            for (int j = 0; j < fieldsNodes.getLength(); ++j) {
                Node fieldNode = fieldsNodes.item(j);
                if (fieldNode.getNodeType() != 1) continue;
                Element field = (Element)fieldNode;
                String fieldName = field.getAttribute("name");
                String fieldValue = field.getTextContent();
                solrDocument.addField(fieldName, (Object)fieldValue);
            }
            solrDocuments.add(solrDocument);
        }
        return solrDocuments;
    }

    private static Document parseXmlDocument(InputStream xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(xml);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing XML file.", exception);
        }
    }

    public static void createGeometryFieldType(HttpSolrClient client) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "geometry");
        attributes.put("class", "solr.SpatialRecursivePrefixTreeFieldType");
        attributes.put("geo", "true");
        attributes.put("maxDistErr", "0.001");
        attributes.put("distErrPct", "0.025");
        attributes.put("distanceUnits", "kilometers");
        attributes.put("spatialContextFactory", "JTS");
        TestsSolrUtils.createFieldType(client, attributes);
    }

    public static void createField(HttpSolrClient client, String name, String type, boolean multiValued) {
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", name);
        field.put("type", type);
        field.put("multiValued", multiValued ? "true" : "false");
        Response addResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.AddField(field));
        if (!addResponse.hasErrors()) {
            return;
        }
        Response replaceResponse = TestsSolrUtils.runSolrRequest(client, (SolrRequest<? extends SolrResponseBase>)new SchemaRequest.ReplaceField(field));
        if (replaceResponse.hasErrors()) {
            Response.throwIfNeeded(addResponse, replaceResponse);
        }
    }

    public static File createTempDirectory(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating temporary directory.", exception);
        }
    }

    public static void cleanIndex(HttpSolrClient client) {
        long indexed;
        SolrQuery query = new SolrQuery("*:*");
        query.setRows(Integer.valueOf(0));
        try {
            indexed = client.query((SolrParams)query).getResults().getNumFound();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error counting the number of document indexed int he Apache Solr target core.", exception);
        }
        if (indexed > 25L) {
            throw new RuntimeException("The target core contains more than 25 documents, please double check the correct core is used and manually delete all documents.");
        }
        try {
            client.deleteByQuery("*:*");
            client.commit();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error removing Apache Solr indexed data.", exception);
        }
    }

    public static final class Response {
        private final boolean errors;
        private final String message;
        private static final Response NO_ERRORS = new Response(false, null);

        private Response(boolean errors, String message) {
            this.errors = errors;
            this.message = message;
        }

        private boolean hasErrors() {
            return this.errors;
        }

        private String getMessage() {
            return this.message;
        }

        private void throwIfNeeded() {
            if (this.errors) {
                throw new RuntimeException(String.format("Something bad happen when executing Solr request '%s'.", this.message));
            }
        }

        private static Response parse(SolrResponseBase response) {
            if (response.getResponse().get("errors") != null) {
                return new Response(true, response.toString());
            }
            return NO_ERRORS;
        }

        private static void throwIfNeeded(Response ... responses) {
            String errors = Arrays.stream(responses).filter(Response::hasErrors).map(Response::getMessage).collect(Collectors.joining(", "));
            if (!errors.isEmpty()) {
                throw new RuntimeException(String.format("Something bad happen when executing Solr request(s) '%s'.", errors));
            }
        }
    }
}

