/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrDataStoreFactory;
import org.geotools.data.solr.SolrFeatureSource;
import org.geotools.data.solr.SolrLayerConfiguration;
import org.geotools.data.solr.TestsSolrUtils;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

public abstract class SolrTestSupport
extends OnlineTestCase {
    protected static final Logger LOGGER = Logging.getLogger(SolrTestSupport.class);
    protected SolrFeatureSource featureSource;
    protected SolrDataStore dataStore;
    protected String layerName = "active";
    protected int SOURCE_SRID = 4326;
    protected String pkField;
    private ArrayList<SolrAttribute> attributes;
    protected DateFormat df = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss");
    private HttpSolrClient solrClient;

    protected void setUpInternal() throws Exception {
        String coreUrl = this.fixture.getProperty(SolrDataStoreFactory.URL.key);
        this.solrClient = TestsSolrUtils.instantiateClient(coreUrl);
        TestsSolrUtils.cleanIndex(this.solrClient);
        TestsSolrUtils.createWktFieldType(this.solrClient);
        TestsSolrUtils.createBboxFieldType(this.solrClient);
        TestsSolrUtils.createWktField(this.solrClient, "geo");
        TestsSolrUtils.createWktField(this.solrClient, "geo2");
        TestsSolrUtils.createBboxField(this.solrClient, "geo3");
        try (InputStream documents = TestsSolrUtils.resourceToStream("/wifiAccessPoint.xml");){
            TestsSolrUtils.runUpdateRequest(this.solrClient, documents);
        }
    }

    protected void connect() throws Exception {
        String url = this.fixture.getProperty(SolrDataStoreFactory.URL.key);
        Map<String, Object> params = this.createConnectionParams(url, this.fixture);
        SolrDataStoreFactory factory = new SolrDataStoreFactory();
        this.dataStore = (SolrDataStore)factory.createDataStore(params);
        this.attributes = this.dataStore.getSolrAttributes(this.layerName);
        for (SolrAttribute at : this.attributes) {
            if (at.isPk().booleanValue()) {
                this.pkField = at.getName();
            }
            if (Geometry.class.isAssignableFrom(at.getType())) {
                at.setSrid(Integer.valueOf(this.SOURCE_SRID));
            }
            at.setUse(Boolean.valueOf(true));
        }
    }

    protected Map<String, Object> createConnectionParams(String url, Properties fixture) {
        String field = "status_s";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SolrDataStoreFactory.URL.key, url);
        params.put(SolrDataStoreFactory.FIELD.key, field);
        params.put(SolrDataStoreFactory.NAMESPACE.key, SolrDataStoreFactory.NAMESPACE.sample);
        return params;
    }

    protected void init() throws Exception {
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.init(this.layerName);
    }

    protected void init(String layerName) throws Exception {
        this.init(layerName, "geo");
    }

    protected void init(String layerName, String geometryField) throws Exception {
        this.layerName = layerName;
        SolrLayerConfiguration solrLayerConfiguration = new SolrLayerConfiguration(new ArrayList());
        solrLayerConfiguration.setLayerName(this.layerName);
        ArrayList<SolrAttribute> layerAttributes = new ArrayList<SolrAttribute>();
        for (SolrAttribute solrAttribute : this.attributes) {
            if (geometryField.equals(solrAttribute.getName())) {
                SolrAttribute copy = new SolrAttribute(solrAttribute);
                copy.setDefaultGeometry(Boolean.valueOf(true));
                layerAttributes.add(copy);
                continue;
            }
            layerAttributes.add(solrAttribute);
        }
        solrLayerConfiguration.getAttributes().addAll(layerAttributes);
        this.dataStore.setSolrConfigurations(solrLayerConfiguration);
        this.featureSource = (SolrFeatureSource)this.dataStore.getFeatureSource(this.layerName);
    }

    protected void disconnect() {
        this.dataStore.dispose();
        try {
            this.solrClient.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error closing Solr client.", exception);
        }
    }

    protected String getFixtureId() {
        return SolrDataStoreFactory.NAMESPACE.sample.toString();
    }

    protected Date date(String date) throws ParseException {
        return this.df.parse(date);
    }

    protected Instant instant(String d) throws ParseException {
        return new DefaultInstant((Position)new DefaultPosition(this.date(d)));
    }

    protected Period period(String d1, String d2) throws ParseException {
        return new DefaultPeriod(this.instant(d1), this.instant(d2));
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINE);
        Logging.getLogger(SolrTestSupport.class).setLevel(Level.FINE);
        Logging.getLogger(SolrTestSupport.class).addHandler(handler);
    }
}

