/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.text.NumberFormat;
import java.util.Locale;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;

public class SolrSpatialStrategyTest {
    @Test
    public void testCreate() throws Exception {
        Assert.assertTrue((boolean)(SolrSpatialStrategy.createStrategy((GeometryDescriptor)this.newDescriptor(null)) instanceof SolrSpatialStrategy.DefaultStrategy));
        Assert.assertTrue((boolean)(SolrSpatialStrategy.createStrategy((GeometryDescriptor)this.newDescriptor("org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType")) instanceof SolrSpatialStrategy.DefaultStrategy));
        Assert.assertTrue((boolean)(SolrSpatialStrategy.createStrategy((GeometryDescriptor)this.newDescriptor("org.apache.solr.schema.LatLonType")) instanceof SolrSpatialStrategy.DefaultStrategy));
        Assert.assertTrue((boolean)(SolrSpatialStrategy.createStrategy((GeometryDescriptor)this.newDescriptor("org.apache.solr.schema.BBoxField")) instanceof SolrSpatialStrategy.BBoxStrategy));
        Assert.assertTrue((boolean)(SolrSpatialStrategy.createStrategy((GeometryDescriptor)this.newDescriptor("org.apache.solr.spatial.pending.BBoxFieldType")) instanceof SolrSpatialStrategy.BBoxStrategy));
    }

    @Test
    public void testDefaultStrategy() throws Exception {
        SolrSpatialStrategy.DefaultStrategy ss = new SolrSpatialStrategy.DefaultStrategy();
        Geometry g = ss.decode("POINT (0 0)");
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof Point));
        Assert.assertEquals((Object)"POINT (0 0)", (Object)ss.encode(g));
    }

    @Test
    public void testBBoxStrategy() throws Exception {
        SolrSpatialStrategy.BBoxStrategy ss = new SolrSpatialStrategy.BBoxStrategy();
        Geometry g = ss.decode("ENVELOPE(1, 3, 4, 2)");
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof Polygon));
        String[] bbox = ss.encode(g).split(",");
        bbox[0] = bbox[0].substring(bbox[0].indexOf("(") + 1, bbox[0].length());
        bbox[3] = bbox[3].substring(0, bbox[3].indexOf(")"));
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        Assert.assertEquals((double)1.0, (double)format.parse(bbox[0]).doubleValue(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)format.parse(bbox[1]).doubleValue(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)format.parse(bbox[2]).doubleValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)format.parse(bbox[3]).doubleValue(), (double)0.1);
    }

    GeometryDescriptor newDescriptor(String solrTypeValue) {
        FeatureTypeFactoryImpl ftf = new FeatureTypeFactoryImpl();
        GeometryType type = ftf.createGeometryType((Name)new NameImpl("fooType"), Geometry.class, null, false, false, null, null, null);
        GeometryDescriptor att = ftf.createGeometryDescriptor(type, (Name)new NameImpl("foo"), 1, 1, true, null);
        att.getUserData().put("solr_type", solrTypeValue);
        return att;
    }
}

