/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.solr.SolrTypeData;
import org.geotools.data.solr.StationData;
import org.geotools.data.solr.TestsSolrUtils;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.URLs;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AppSchemaOnlineTestSupport
extends OnlineTestCase {
    public static final String PG_HOST_KEY = "pg_host";
    public static final String PG_PORT_KEY = "pg_port";
    public static final String PG_DATABASE_KEY = "pg_db";
    public static final String PG_USER_KEY = "pg_user";
    public static final String PG_PASS_KEY = "pg_pass";
    public static final String SOLR_URL_KEY = "solr_url";
    protected String CORE_NAME = "stations";
    protected String typesFileName = "solr_types.xml";
    protected String solrDataFilename = "stationsData.xml";
    protected String testData = "/test-data/appschema/";
    protected String xsdFileName = "meteo.xsd";
    protected String xmlFileName = "mappings_solr.xml";
    protected String ST_NAMESPACE = "http://www.stations.org/1.0";
    protected Name mappedTypeName = Types.typeName((String)"StationType-f46d72da-5591-4873-b210-5ed30a6ffb0d");
    @Rule
    public TemporaryFolder tempfolder = new TemporaryFolder();
    protected File tempDir;
    protected File appSchemaCacheDir;
    protected HttpSolrClient client;
    protected DataAccess<FeatureType, Feature> mappingDataStore;

    protected void copyTestData(String baseFileName, File destDir) throws IOException {
        destDir.mkdirs();
        FileUtils.copyFileToDirectory((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource(this.testData + baseFileName)), (File)destDir);
    }

    private void createTestFolder() throws IOException {
        this.tempfolder.create();
        this.tempDir = this.tempfolder.newFolder(((Object)((Object)this)).getClass().getSimpleName());
        this.appSchemaCacheDir = new File(this.tempDir.getPath() + "/app-schema-cache");
        this.appSchemaCacheDir.mkdir();
    }

    protected void setUpInternal() throws Exception {
        this.configFieldsSetup();
        this.createTestFolder();
        this.client = new HttpSolrClient.Builder(this.getSolrCoreURL()).build();
        this.solrDataSetup();
        this.prepareFiles();
        this.setupDataStore();
    }

    protected void configFieldsSetup() {
    }

    private void setupDataStore() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = new URL(this.tempDir.toURI().toURL().toExternalForm() + File.separator + this.xmlFileName);
        dsParams.put("url", url.toExternalForm());
        this.mappingDataStore = DataAccessFinder.getDataStore(dsParams);
    }

    protected String getSolrCoreURL() {
        return this.fixture.getProperty(SOLR_URL_KEY) + "/" + this.CORE_NAME;
    }

    protected void solrDataSetup() throws Exception {
        this.typeSetup();
        this.fieldsSetup();
        this.indexSetup();
    }

    private void typeSetup() {
        TestsSolrUtils.createGeometryFieldType(this.client);
    }

    protected void fieldsSetup() throws Exception {
        File inFile = new File(((Object)((Object)this)).getClass().getResource(this.testData + this.typesFileName).toURI());
        JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{SolrTypeData.SolrTypes.class});
        Unmarshaller um = jcontext.createUnmarshaller();
        SolrTypeData.SolrTypes types = (SolrTypeData.SolrTypes)um.unmarshal(inFile);
        for (SolrTypeData adata : types.getTypes()) {
            this.createField(adata.getName(), adata.getType(), adata.getMulti());
        }
    }

    protected void indexSetup() throws Exception {
        File inFile = new File(((Object)((Object)this)).getClass().getResource(this.testData + this.solrDataFilename).toURI());
        JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{StationData.Stations.class});
        Unmarshaller um = jcontext.createUnmarshaller();
        StationData.Stations stations = (StationData.Stations)um.unmarshal(inFile);
        for (StationData adata : stations.getStations()) {
            this.client.add(adata.toSolrDoc());
        }
        this.client.commit();
    }

    protected void createField(String name, String type, boolean multiValued) {
        TestsSolrUtils.createField(this.client, name, type, multiValued);
    }

    protected void prepareFiles() throws Exception {
        this.copyTestData(this.xsdFileName, this.tempDir);
        File xmlFile = URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource(this.testData + this.xmlFileName));
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new FileInputStream(xmlFile)));
        Node solrDs = doc.getElementsByTagName("SolrDataStore").item(0);
        NodeList dsChilds = solrDs.getChildNodes();
        for (int i = 0; i < dsChilds.getLength(); ++i) {
            Node achild = dsChilds.item(i);
            if (!achild.getNodeName().equals("url")) continue;
            achild.setTextContent(this.getSolrCoreURL());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(this.tempDir.getPath() + "/" + this.xmlFileName));
        transformer.transform(source, result);
    }

    protected String getFixtureId() {
        return null;
    }
}

