/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr.complex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.data.solr.TestsSolrUtils;
import org.geotools.data.solr.complex.SchemaField;
import org.geotools.data.solr.complex.Station;

public final class StationsSetup {
    private StationsSetup() {
    }

    public static void setupSolrIndex(HttpSolrClient client) {
        TestsSolrUtils.cleanIndex(client);
        StationsSetup.setupStationsIndexSchema(client);
        StationsSetup.indexStationsData(client);
    }

    public static void prepareAppSchemaFiles(File testDirectory, String solrUrl) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("SOLR_URL", solrUrl);
        context.put("CORE_NAME", StationsSetup.getUrlBasePathLastElement(solrUrl));
        StationsSetup.copyResource("/solr/complex/stations.xsd", new File(testDirectory, "stations.xsd"), Collections.emptyMap());
        StationsSetup.copyResource("/solr/complex/mappings.xml", new File(testDirectory, "mappings.xml"), context);
    }

    private static void setupStationsIndexSchema(HttpSolrClient client) {
        TestsSolrUtils.createGeometryFieldType(client);
        SchemaField.SchemaFields schemaFields = StationsSetup.parseXmlResource("/solr/complex/stations_schema.xml", SchemaField.SchemaFields.class);
        for (SchemaField schemaField : schemaFields.getFields()) {
            TestsSolrUtils.createField(client, schemaField.getName(), schemaField.getType(), schemaField.getMulti());
        }
    }

    private static void indexStationsData(HttpSolrClient client) {
        Station.Stations stations = StationsSetup.parseXmlResource("/solr/complex/stations_data.xml", Station.Stations.class);
        for (Station station : stations.getStations()) {
            try {
                client.add(station.toSolrDoc());
            }
            catch (Exception exception) {
                throw new RuntimeException("Error indexing station data in apache Solr.", exception);
            }
        }
        try {
            client.commit();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error when forcing Apache Solr to index any pending document.", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T parseXmlResource(String resource, Class<T> resultType) {
        try (InputStream input = StationsSetup.class.getResourceAsStream(resource);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{resultType});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(input);
            return (T)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error parsing resource '%s'.", resource), exception);
        }
    }

    private static void copyResource(String resource, File destination, Map<String, String> context) {
        try (InputStream input = StationsSetup.class.getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(destination);){
            if (context.isEmpty()) {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            } else {
                String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                content = StationsSetup.replace(content, context);
                IOUtils.write((String)content, (OutputStream)output, (String)"UTF-8");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error copying resource to destination.", exception);
        }
    }

    private static String replace(String text, Map<String, String> context) {
        for (Map.Entry<String, String> entry : context.entrySet()) {
            String key = String.format("\\$\\{%s}", entry.getKey());
            text = text.replaceAll(key, entry.getValue());
        }
        return text;
    }

    private static String getUrlBasePathLastElement(String url) {
        int index = url.lastIndexOf("/");
        if (index == url.length() - 1) {
            url = url.substring(0, index);
            index = url.lastIndexOf("/");
        }
        if (index < 0) {
            return null;
        }
        return url.substring(index + 1, url.length());
    }
}

