/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.solr.SolrTestSupport;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.util.FeatureStreams;
import org.geotools.feature.FeatureCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import si.uom.SI;

public class SolrGeometryTest
extends SolrTestSupport {
    public void testBBOXLimitSplittedFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        BBOX bbox = ff.bbox("geo", -185.0, -98.0, 185.0, 98.0, "EPSG:" + this.SOURCE_SRID);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)bbox);
        SolrGeometryTest.assertEquals((int)11, (int)features.size());
    }

    public void testPolygonLimitSplittedFilter() throws Exception {
        this.init();
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{-185.0, -98.0, 185.0, -98.0, 185.0, 98.0, -185.0, 98.0, -185.0, -98.0}, 2));
        Within f = ff.within((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)11, (int)features.size());
    }

    public void testClipToWorldFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property = ff.equals((Expression)ff.property("standard_ss"), (Expression)ff.literal((Object)"IEEE 802.11b"));
        BBOX bbox = ff.bbox("geo", -190.0, -190.0, 190.0, 190.0, "EPSG:" + this.SOURCE_SRID);
        And filter = ff.and((Filter)property, (Filter)bbox);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        SolrGeometryTest.assertEquals((int)7, (int)features.size());
    }

    public void testCrossesFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{0.0, 0.0, 2.0, 2.0}, 2));
        Crosses f = ff.crosses((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testNotCrossesFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{0.0, 0.0, 1.0, 1.0}, 2));
        Crosses f = ff.crosses((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)0, (int)features.size());
    }

    public void testEqualFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{3.0, 2.0, 6.0, 2.0, 6.0, 7.0, 3.0, 7.0, 3.0, 2.0}, 2));
        Equals f = ff.equal((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.13");
        }
    }

    public void testDisjointFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Point ls = gf.createPoint(sf.create(new double[]{0.0, 0.0}, 2));
        Disjoint f = ff.disjoint((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        try (Stream featureStream = FeatureStreams.toFeatureStream((FeatureCollection)features);){
            List featuresList = featureStream.collect(Collectors.toList());
            SolrGeometryTest.assertEquals((int)11, (int)featuresList.size());
            SolrGeometryTest.assertTrue((String)"not-active.11 ID not found", (boolean)featuresList.stream().anyMatch(x -> "not-active.11".equals(x.getID())));
            SolrGeometryTest.assertTrue((String)"not-active.12 ID not found", (boolean)featuresList.stream().anyMatch(x -> "not-active.12".equals(x.getID())));
            SolrGeometryTest.assertTrue((String)"not-active.10 ID found", (boolean)featuresList.stream().noneMatch(x -> "not-active.10".equals(x.getID())));
            SolrGeometryTest.assertTrue((String)"not-active.1 ID found", (boolean)featuresList.stream().noneMatch(x -> "not-active.1".equals(x.getID())));
        }
    }

    public void testTouchesFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Point ls = gf.createPoint(sf.create(new double[]{1.0, 1.0}, 2));
        Touches f = ff.touches((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testWithinFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{0.0, 0.0, 0.0, 6.0, 6.0, 6.0, 6.0, 0.0, 0.0, 0.0}, 2));
        Within f = ff.within((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testOverlapsFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{5.5, 6.0, 7.0, 6.0, 7.0, 7.0, 5.5, 7.0, 5.5, 6.0}, 2));
        Overlaps f = ff.overlaps((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.13");
        }
    }

    public void testIntersectsFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{6.0, 6.0, 7.0, 6.0, 7.0, 7.0, 6.0, 7.0, 6.0, 6.0}, 2));
        Intersects f = ff.intersects((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.13");
        }
    }

    public void testContainsFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Polygon ls = gf.createPolygon(sf.create(new double[]{2.0, 2.0, 3.0, 2.0, 3.0, 3.0, 2.0, 3.0, 2.0, 2.0}, 2));
        Contains f = ff.contains((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testDWithinFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Point ls = gf.createPoint(sf.create(new double[]{1.0, 1.0}, 2));
        DWithin f = ff.dwithin((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls), 3.0, SI.METRE.getSymbol());
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        try (Stream featureStream = FeatureStreams.toFeatureStream((FeatureCollection)features);){
            List featuresList = featureStream.collect(Collectors.toList());
            SolrGeometryTest.assertEquals((int)5, (int)featuresList.size());
            SolrGeometryTest.assertTrue((String)"not-active.12 ID not found", (boolean)featuresList.stream().anyMatch(x -> "not-active.12".equals(x.getID())));
            SolrGeometryTest.assertTrue((String)"not-active.13 ID not found", (boolean)featuresList.stream().anyMatch(x -> "not-active.13".equals(x.getID())));
        }
    }

    public void testBeyondFilter() throws Exception {
        this.init("not-active");
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        Point ls = gf.createPoint(sf.create(new double[]{1.0, 1.0}, 2));
        Beyond f = ff.beyond((Expression)ff.property("geo"), (Expression)ff.literal((Object)ls), 1.0, SI.METRE.getSymbol());
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        try (Stream featureStream = FeatureStreams.toFeatureStream((FeatureCollection)features);){
            List featuresList = featureStream.collect(Collectors.toList());
            SolrGeometryTest.assertEquals((int)12, (int)featuresList.size());
            SolrGeometryTest.assertTrue((String)"not-active.13 ID not found", (boolean)featuresList.stream().anyMatch(x -> "not-active.13".equals(x.getID())));
            SolrGeometryTest.assertTrue((String)"not-active.12 ID found", (boolean)featuresList.stream().noneMatch(x -> "not-active.12".equals(x.getID())));
        }
    }

    public void testAlternateGeometry() throws Exception {
        this.init("active", "geo2");
        SimpleFeatureType schema = this.featureSource.getSchema();
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        SolrGeometryTest.assertNotNull((Object)gd);
        SolrGeometryTest.assertEquals((String)"geo2", (String)gd.getLocalName());
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        BBOX bbox = ff.bbox("geo2", 6.5, 23.5, 7.5, 24.5, "EPSG:4326");
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)bbox);
        SolrGeometryTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrGeometryTest.assertTrue((boolean)fsi.hasNext());
            SolrGeometryTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"active.9");
        }
    }
}

