/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index.quadtree.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.geotools.data.shapefile.index.quadtree.Node;
import org.geotools.data.shapefile.index.quadtree.StoreException;
import org.geotools.util.NIOUtilities;
import org.locationtech.jts.geom.Envelope;

public class FileSystemNode
extends Node {
    static final int[] ZERO = new int[0];
    private ScrollingBuffer buffer;
    private int subNodeStartByte;
    private int subNodesLength;
    private int numSubNodes;

    FileSystemNode(Envelope bounds, ScrollingBuffer buffer, int startByte, int subNodesLength) {
        super(bounds);
        this.buffer = buffer;
        this.subNodeStartByte = startByte;
        this.subNodesLength = subNodesLength;
    }

    @Override
    public Node copy() throws IOException {
        FileSystemNode copy = new FileSystemNode(this.getBounds(), this.buffer, this.subNodeStartByte, this.subNodesLength);
        copy.numShapesId = this.numShapesId;
        copy.shapesId = new int[this.numShapesId];
        System.arraycopy(this.shapesId, 0, copy.shapesId, 0, this.numShapesId);
        copy.numSubNodes = this.numSubNodes;
        return copy;
    }

    @Override
    public int getNumSubNodes() {
        return this.numSubNodes;
    }

    public void setNumSubNodes(int numSubNodes) {
        this.numSubNodes = numSubNodes;
    }

    public int getSubNodeStartByte() {
        return this.subNodeStartByte;
    }

    public int getSubNodesLength() {
        return this.subNodesLength;
    }

    @Override
    public Node getSubNode(int pos) throws StoreException {
        if (this.subNodes.size() > pos) {
            return super.getSubNode(pos);
        }
        try {
            FileSystemNode subNode = null;
            int offset = this.subNodeStartByte;
            if (pos > 0) {
                subNode = (FileSystemNode)this.getSubNode(pos - 1);
                offset = subNode.getSubNodeStartByte() + subNode.getSubNodesLength();
            }
            this.buffer.goTo(offset);
            int ii = this.subNodes.size();
            for (int i = 0; i < pos + 1 - ii; ++i) {
                subNode = FileSystemNode.readNode(pos, this, this.buffer);
                this.addSubNode(subNode);
            }
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        return super.getSubNode(pos);
    }

    public static FileSystemNode readNode(int id, Node parent, FileChannel channel, ByteOrder order, boolean useMemoryMapping) throws IOException {
        ScrollingBuffer buffer = new ScrollingBuffer(channel, order, useMemoryMapping);
        return FileSystemNode.readNode(id, parent, buffer);
    }

    static FileSystemNode readNode(int id, Node parent, ScrollingBuffer buf) throws IOException {
        int offset = buf.getInt();
        Envelope env = buf.getEnvelope();
        int numShapesId = buf.getInt();
        int[] ids = null;
        if (numShapesId > 0) {
            ids = new int[numShapesId];
            buf.getIntArray(ids);
        } else {
            ids = ZERO;
        }
        int numSubNodes = buf.getInt();
        FileSystemNode node = new FileSystemNode(env, buf, (int)buf.getPosition(), offset);
        node.setShapesId(ids);
        node.setNumSubNodes(numSubNodes);
        return node;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        this.buffer = null;
    }

    private static class ScrollingBuffer {
        FileChannel channel;
        ByteOrder order;
        ByteBuffer buffer;
        long bufferStart;
        double[] envelope = new double[4];
        boolean useMemoryMapping;

        public ScrollingBuffer(FileChannel channel, ByteOrder order, boolean useMemoryMapping) throws IOException {
            this.channel = channel;
            this.order = order;
            this.useMemoryMapping = useMemoryMapping;
            this.bufferStart = channel.position();
            if (useMemoryMapping) {
                this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, channel.position(), channel.size() - channel.position());
                this.buffer.order(order);
            } else {
                this.buffer = NIOUtilities.allocate((int)8192);
                this.buffer.order(order);
                channel.read(this.buffer);
                this.buffer.flip();
            }
        }

        public void close() {
            if (this.buffer != null) {
                NIOUtilities.clean((ByteBuffer)this.buffer, (boolean)this.useMemoryMapping);
                this.buffer = null;
            }
        }

        public int getInt() throws IOException {
            if (!this.useMemoryMapping && this.buffer.remaining() < 4) {
                this.refillBuffer(4);
            }
            return this.buffer.getInt();
        }

        public Envelope getEnvelope() throws IOException {
            if (!this.useMemoryMapping && this.buffer.remaining() < 32) {
                this.refillBuffer(32);
            }
            this.buffer.asDoubleBuffer().get(this.envelope);
            this.buffer.position(this.buffer.position() + 32);
            return new Envelope(this.envelope[0], this.envelope[2], this.envelope[1], this.envelope[3]);
        }

        public void getIntArray(int[] array) throws IOException {
            int size = array.length * 4;
            if (this.buffer.remaining() < size) {
                this.refillBuffer(size);
            }
            IntBuffer intView = this.buffer.asIntBuffer();
            intView.limit(array.length);
            intView.get(array);
            this.buffer.position(this.buffer.position() + size);
        }

        void refillBuffer(int requiredSize) throws IOException {
            long currentPosition = this.bufferStart + (long)this.buffer.position();
            if (this.buffer.capacity() < requiredSize) {
                int size;
                for (size = this.buffer.capacity(); size < requiredSize; size *= 2) {
                }
                this.buffer = NIOUtilities.allocate((int)size);
                this.buffer.order(this.order);
            }
            this.readBuffer(currentPosition);
        }

        private void readBuffer(long currentPosition) throws IOException {
            this.channel.position(currentPosition);
            this.buffer.clear();
            this.channel.read(this.buffer);
            this.buffer.flip();
            this.bufferStart = currentPosition;
        }

        public void goTo(long newPosition) throws IOException {
            if (this.useMemoryMapping || newPosition >= this.bufferStart && newPosition <= this.bufferStart + (long)this.buffer.limit()) {
                this.buffer.position((int)(newPosition - this.bufferStart));
            } else {
                this.readBuffer(newPosition);
            }
        }

        public long getPosition() {
            return this.bufferStart + (long)this.buffer.position();
        }
    }
}

