/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.PrjFileReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.shapefile.CloseableIteratorWrapper;
import org.geotools.data.shapefile.IndexManager;
import org.geotools.data.shapefile.IndexedShapefileFeatureReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.ShapefileSetManager;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.fid.IndexedFidReader;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.index.Data;
import org.geotools.data.shapefile.index.TreeException;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.util.ScreenMap;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Classes;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class ShapefileFeatureSource
extends ContentFeatureSource {
    static final Logger LOGGER = Logging.getLogger(ShapefileFeatureSource.class);
    ShpFiles shpFiles;

    public ShapefileFeatureSource(ContentEntry entry, ShpFiles shpFiles) {
        super(entry, Query.ALL);
        this.shpFiles = shpFiles;
        HashSet<Object> hints = new HashSet<Object>();
        hints.add(Hints.FEATURE_DETACHED);
        hints.add(Hints.JTS_GEOMETRY_FACTORY);
        hints.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        hints.add(Hints.GEOMETRY_DISTANCE);
        hints.add(Hints.SCREENMAP);
        this.hints = Collections.unmodifiableSet(hints);
    }

    public ShapefileDataStore getDataStore() {
        return (ShapefileDataStore)super.getDataStore();
    }

    protected boolean canFilter(Query query) {
        return true;
    }

    protected boolean canRetype(Query query) {
        return true;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope referencedEnvelope;
        block10: {
            if (query.getFilter() != Filter.INCLUDE) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.allocate(100);
            FileReader reader = () -> "Shapefile Datastore's getBounds Method";
            ReadableByteChannel in = this.shpFiles.getReadChannel(ShpFileType.SHP, reader);
            try {
                in.read(buffer);
                buffer.flip();
                ShapefileHeader header = new ShapefileHeader();
                header.read(buffer, true);
                SimpleFeatureType schema = this.getSchema();
                Envelope env = header.getFileLength() == 50 ? new Envelope() : new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
                CoordinateReferenceSystem crs = null;
                if (schema != null) {
                    crs = schema.getCoordinateReferenceSystem();
                }
                referencedEnvelope = new ReferencedEnvelope(env, crs);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new DataSourceException("Problem getting Bbox", (Throwable)ioe);
                }
            }
            in.close();
        }
        return referencedEnvelope;
    }

    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            try (IndexFile file = this.getDataStore().shpManager.openIndexFile();){
                if (file != null) {
                    int n = file.getRecordCount();
                    return n;
                }
            }
            int count = -1;
            try (ShapefileReader reader = this.getDataStore().shpManager.openShapeReader(new GeometryFactory(), false);){
                count = reader.getCount(count);
            }
            return count;
        }
        return -1;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query q) throws IOException {
        boolean shpFileMayExist;
        SimpleFeatureType resultSchema = this.getResultSchema(q);
        SimpleFeatureType readSchema = this.getReadSchema(q);
        GeometryFactory geometryFactory = this.getGeometryFactory(q);
        ReferencedEnvelope bbox = new ReferencedEnvelope();
        if (q != null && q.getFilter() != null && (bbox = (Envelope)q.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)bbox)) == null) {
            bbox = new ReferencedEnvelope();
        }
        Filter filter = q != null ? q.getFilter() : null;
        IndexManager indexManager = this.getDataStore().indexManager;
        CloseableIterator<Data> goodRecs = null;
        if (this.getDataStore().isFidIndexed() && filter instanceof Id && indexManager.hasFidIndex(false)) {
            List<Data> records;
            Id fidFilter = (Id)filter;
            if (indexManager.isIndexStale(ShpFileType.FIX)) {
                indexManager.createFidIndex();
            }
            if ((records = indexManager.queryFidIndex(fidFilter)) != null) {
                goodRecs = new CloseableIteratorWrapper<Data>(records.iterator());
            }
        } else if (this.getDataStore().isIndexed() && !bbox.isNull() && !Double.isInfinite(bbox.getWidth()) && !Double.isInfinite(bbox.getHeight())) {
            try {
                if (indexManager.isSpatialIndexAvailable() || this.getDataStore().isIndexCreationEnabled()) {
                    goodRecs = indexManager.querySpatialIndex((Envelope)bbox);
                }
            }
            catch (TreeException e) {
                throw new IOException("Error querying index: " + e.getMessage());
            }
        }
        if (goodRecs != null && !goodRecs.hasNext()) {
            LOGGER.log(Level.FINE, "Empty results for " + resultSchema.getName().getLocalPart() + ", skipping read");
            goodRecs.close();
            return new EmptyFeatureReader((FeatureType)resultSchema);
        }
        IndexedFidReader fidReader = null;
        if (this.getDataStore().isFidIndexed() && indexManager.hasFidIndex(false)) {
            fidReader = new IndexedFidReader(this.shpFiles);
        }
        ShapefileSetManager shpManager = this.getDataStore().shpManager;
        ShapefileReader shapeReader = null;
        boolean bl = shpFileMayExist = !shpManager.shpFiles.isLocal() || shpManager.shpFiles.exists(ShpFileType.SHP);
        if (shpFileMayExist) {
            try {
                ShapefileReader sr;
                shapeReader = sr = shpManager.openShapeReader(geometryFactory, goodRecs != null);
            }
            catch (FileNotFoundException e) {
                String format = "Ignoring missing shp-file and moving on: %s";
                LOGGER.fine(() -> String.format("Ignoring missing shp-file and moving on: %s", e.getMessage()));
            }
        } else {
            LOGGER.fine("Ignoring missing shp-file and moving on.");
        }
        DbaseFileReader dbfReader = null;
        List attributes = readSchema.getAttributeDescriptors();
        if (attributes.isEmpty() || attributes.size() == 1 && readSchema.getGeometryDescriptor() != null) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
        } else {
            dbfReader = shpManager.openDbfReader(goodRecs != null);
        }
        ShapefileFeatureReader reader = goodRecs != null ? new IndexedShapefileFeatureReader(readSchema, shapeReader, dbfReader, fidReader, goodRecs) : new ShapefileFeatureReader(readSchema, shapeReader, dbfReader, fidReader);
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            reader.setFilter(filter);
        }
        if (q != null) {
            Hints hints;
            if (bbox != null && !bbox.isNull()) {
                reader.setTargetBBox((Envelope)bbox);
            }
            if ((hints = q.getHints()) != null) {
                Number simplificationDistance = (Number)hints.get((Object)Hints.GEOMETRY_DISTANCE);
                if (simplificationDistance != null) {
                    reader.setSimplificationDistance(simplificationDistance.doubleValue());
                }
                reader.setScreenMap((ScreenMap)hints.get((Object)Hints.SCREENMAP));
                if (Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D))) {
                    shapeReader.setFlatGeometry(true);
                }
            }
        }
        if (!FeatureTypes.equals((SimpleFeatureType)readSchema, (SimpleFeatureType)resultSchema)) {
            return new ReTypeFeatureReader((FeatureReader)reader, resultSchema);
        }
        return reader;
    }

    SimpleFeatureType getResultSchema(Query q) {
        if (q.getPropertyNames() == null) {
            return this.getSchema();
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])q.getPropertyNames());
    }

    SimpleFeatureType getReadSchema(Query q) {
        if (q.getPropertyNames() == Query.ALL_NAMES) {
            return this.getSchema();
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        attributes.addAll(Arrays.asList(q.getPropertyNames()));
        Filter filter = q.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            AbsoluteAttributeExtractor fat = new AbsoluteAttributeExtractor(this.getSchema());
            filter.accept((FilterVisitor)fat, null);
            attributes.addAll(fat.getAttributeNameSet());
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), new ArrayList(attributes));
    }

    protected GeometryFactory getGeometryFactory(Query query) {
        if (query == null || query.getHints() == null) {
            GeometryFactory geometryFactory = this.entry.getDataStore().getGeometryFactory();
            return geometryFactory != null ? geometryFactory : new GeometryFactory();
        }
        Hints hints = query.getHints();
        GeometryFactory geometryFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null) {
            CoordinateSequenceFactory csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            geometryFactory = csFactory != null ? new GeometryFactory(csFactory) : this.entry.getDataStore().getGeometryFactory();
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        return geometryFactory;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        GeometryDescriptor geomDescriptor;
        List<AttributeDescriptor> types = this.readAttributes();
        SimpleFeatureType parent = null;
        GeometryDescriptor geometryDescriptor = geomDescriptor = types.get(0) instanceof GeometryDescriptor ? (GeometryDescriptor)types.get(0) : null;
        if (geomDescriptor != null) {
            Class geomBinding = geomDescriptor.getType().getBinding();
            if (geomBinding == Point.class || geomBinding == MultiPoint.class) {
                parent = BasicFeatureTypes.POINT;
            } else if (geomBinding == Polygon.class || geomBinding == MultiPolygon.class) {
                parent = BasicFeatureTypes.POLYGON;
            } else if (geomBinding == LineString.class || geomBinding == MultiLineString.class) {
                parent = BasicFeatureTypes.LINE;
            }
        }
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (geomDescriptor != null) {
            builder.setDefaultGeometry(geomDescriptor.getLocalName());
        }
        builder.addAll(types);
        builder.setName(this.entry.getName());
        builder.setAbstract(false);
        if (parent != null) {
            builder.setSuperType(parent);
        }
        return builder.buildFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AttributeDescriptor> readAttributes() throws IOException {
        ShapefileSetManager shpManager = this.getDataStore().shpManager;
        PrjFileReader prj = null;
        ShapefileReader shp = null;
        DbaseFileReader dbf = null;
        CoordinateReferenceSystem crs = null;
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        try {
            try {
                shp = shpManager.openShapeReader(new GeometryFactory(), false);
            }
            catch (FileNotFoundException e) {
                String format = "Ignoring missing shp-file and moving on: %s";
                LOGGER.fine(() -> String.format("Ignoring missing shp-file and moving on: %s", e.getMessage()));
            }
            dbf = shpManager.openDbfReader(false);
            try {
                prj = shpManager.openPrjReader();
                if (prj != null) {
                    crs = prj.getCoordinateReferenceSystem();
                }
            }
            catch (FactoryException fe) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Ignoring invalid prj file and moving on: " + fe.getMessage());
                }
                crs = null;
            }
            HashSet<String> usedNames = new HashSet<String>();
            if (shp != null) {
                Class<? extends Geometry> geometryClass = JTSUtilities.findBestGeometryClass(shp.getHeader().getShapeType());
                build.setName(Classes.getShortName(geometryClass));
                build.setNillable(true);
                build.setCRS(crs);
                build.setBinding(geometryClass);
                GeometryType geometryType = build.buildGeometryType();
                attributes.add((AttributeDescriptor)build.buildDescriptor("the_geom", geometryType));
                usedNames.add("the_geom");
            }
            if (dbf != null) {
                DbaseFileHeader header = dbf.getHeader();
                int ii = header.getNumFields();
                for (int i = 0; i < ii; ++i) {
                    Class<?> attributeClass = header.getFieldClass(i);
                    Object name = header.getFieldName(i);
                    if (usedNames.contains(name)) {
                        String origional = name;
                        int count = 1;
                        name = (String)name + count;
                        while (usedNames.contains(name)) {
                            name = origional + ++count;
                        }
                        build.addUserData((Object)"original", (Object)origional);
                        build.addUserData((Object)"count", (Object)count);
                    }
                    usedNames.add((String)name);
                    int length = header.getFieldLength(i);
                    build.setNillable(true);
                    build.setLength(length);
                    build.setBinding(attributeClass);
                    attributes.add(build.buildDescriptor((String)name));
                }
            }
            ArrayList<AttributeDescriptor> arrayList = attributes;
            return arrayList;
        }
        finally {
            try {
                if (prj != null) {
                    prj.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (dbf != null) {
                    dbf.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (shp != null) {
                    shp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }

    private final class AbsoluteAttributeExtractor
    extends FilterAttributeExtractor {
        private AbsoluteAttributeExtractor(SimpleFeatureType featureType) {
            super(featureType);
        }

        public Object visit(BBOX filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(Beyond filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(Contains filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(Crosses filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(Disjoint filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(DWithin filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(Touches filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        public Object visit(TOverlaps filter, Object data) {
            data = this.geom(filter.getExpression1(), data);
            data = this.geom(filter.getExpression2(), data);
            return data;
        }

        Object geom(Expression expr, Object data) {
            String propertyName;
            String string = propertyName = expr instanceof PropertyName ? ((PropertyName)expr).getPropertyName() : null;
            if (propertyName != null && propertyName.trim().isEmpty()) {
                if (data != null && data != this.attributeNames) {
                    this.attributeNames = (Set)data;
                }
                this.propertyNames.add((PropertyName)expr);
                GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
                this.attributeNames.add(geometryDescriptor.getName().getLocalPart());
                return data;
            }
            return expr.accept((ExpressionVisitor)this, data);
        }
    }
}

