/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class DataDefinition {
    private Charset charset;
    private ArrayList<Field> fields = new ArrayList();

    public DataDefinition(String charset) {
        this.charset = Charset.forName(charset);
    }

    public final boolean isValid() {
        return this.charset != null && !this.fields.isEmpty();
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public Field getField(int i) {
        return this.fields.get(i);
    }

    public void addField(Class<?> clazz) {
        if (clazz.isAssignableFrom(Short.class)) {
            this.fields.add(new Field(clazz, 2));
        } else if (clazz.isAssignableFrom(Integer.class)) {
            this.fields.add(new Field(clazz, 4));
        } else if (clazz.isAssignableFrom(Long.class)) {
            this.fields.add(new Field(clazz, 8));
        } else if (clazz.isAssignableFrom(Float.class)) {
            this.fields.add(new Field(clazz, 4));
        } else if (clazz.isAssignableFrom(Double.class)) {
            this.fields.add(new Field(clazz, 8));
        } else {
            throw new IllegalArgumentException("Unknow len of class " + String.valueOf(clazz) + "use addField(int)");
        }
    }

    public void addField(int len) {
        this.fields.add(new Field(String.class, len));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getLen() {
        int len = 0;
        Field field = null;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field value;
            field = value = iterator.next();
            len += field.getLen();
        }
        return len;
    }

    public int getEncodedLen() {
        int len = 0;
        Field field = null;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field value;
            field = value = iterator.next();
            len += field.getEncodedLen();
        }
        return len;
    }

    public class Field {
        private Class<?> clazz;
        private int len;

        public Field(Class<?> clazz, int len) {
            this.clazz = clazz;
            this.len = len;
        }

        public Class<?> getFieldClass() {
            return this.clazz;
        }

        public int getLen() {
            return this.len;
        }

        public int getEncodedLen() {
            int ret = this.len;
            if (this.clazz.equals(String.class)) {
                ret = (int)DataDefinition.this.charset.newEncoder().maxBytesPerChar() * this.len;
            }
            return ret;
        }
    }
}

