/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;
import org.xmlunit.matchers.EvaluateXPathMatcher;

public abstract class XmlTestSupport {
    protected Map<String, String> getNamespaces() {
        return Collections.emptyMap();
    }

    public static Namespace Namespace(String prefix, String uri) {
        return new Namespace(prefix, uri);
    }

    public static Map<String, String> namespaces(Namespace ... namespaces) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Namespace namespace : namespaces) {
            result.put(namespace.prefix, namespace.uri);
        }
        return result;
    }

    protected EvaluateXPathMatcher hasXPath(String xPath, Matcher<String> valueMatcher) {
        EvaluateXPathMatcher evaluateXPathMatcher = EvaluateXPathMatcher.hasXPath((String)xPath, valueMatcher);
        return evaluateXPathMatcher.withNamespaceContext(this.getNamespaces());
    }

    protected Diff diffSimilar(Object expected, Object actual) {
        return DiffBuilder.compare((Object)expected).withTest(actual).checkForSimilar().withNamespaceContext(this.getNamespaces()).build();
    }

    public static class Namespace {
        final String prefix;
        final String uri;

        protected Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

