/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixtureUtilities {
    public static Properties loadProperties(File file) {
        Properties properties;
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties properties2 = new Properties();
            properties2.load(input);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)input).close();
        return properties;
    }

    public static File getFixtureDirectory() {
        return new File(System.getProperty("user.home") + File.separator + ".geotools");
    }

    public static File getFixtureFile(File fixtureDirectory, String fixtureId) {
        return new File(fixtureDirectory, fixtureId.replace('.', File.separatorChar).concat(".properties"));
    }

    public static void printSkipNotice(String fixtureId, File fixtureFile) {
        try {
            System.out.println("Skipping " + fixtureId + " tests. Fixture file " + fixtureFile.getCanonicalPath() + " not found.");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    public static Properties loadFixture(String fixtureId) {
        File fixtureFile = FixtureUtilities.getFixtureFile(FixtureUtilities.getFixtureDirectory(), fixtureId);
        if (fixtureFile.exists()) {
            return FixtureUtilities.loadProperties(fixtureFile);
        }
        FixtureUtilities.printSkipNotice(fixtureId, fixtureFile);
        return null;
    }
}

