/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3.cache;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.geotools.s3.S3Connector;
import org.geotools.s3.cache.CacheConfig;
import org.geotools.s3.cache.CacheEntryKey;
import org.geotools.s3.cache.S3ChunkEntryFactory;
import org.geotools.util.logging.Logging;

public enum CacheManagement {
    DEFAULT;

    public static final String DEFAULT_CACHE = "default_cache";
    private CacheManager manager;
    private CacheConfig config;

    private CacheManagement() {
        this.init(false);
    }

    @VisibleForTesting
    final void init(boolean removeCacheIfExists) {
        this.config = CacheConfig.getDefaultConfig();
        this.manager = CacheManagement.buildCache(this.config, removeCacheIfExists);
    }

    private static CacheManager buildCache(CacheConfig config, boolean removeCacheIfExists) {
        Configuration cacheConfig = null;
        if (config.getConfigurationPath() != null) {
            cacheConfig = CacheManagement.loadConfiguration(config.getConfigurationPath());
        }
        if (cacheConfig == null) {
            cacheConfig = new Configuration();
            cacheConfig.setMaxBytesLocalDisk(Long.valueOf(config.getDiskCacheSize()));
            cacheConfig.setMaxBytesLocalHeap(Long.valueOf(config.getHeapSize()));
            if (config.isUseDiskCache()) {
                DiskStoreConfiguration diskConfig = new DiskStoreConfiguration();
                diskConfig.setPath(config.getCacheDirectory().toAbsolutePath().toString());
                cacheConfig.diskStore(diskConfig);
            }
        }
        if (cacheConfig.getDefaultCacheConfiguration() == null) {
            CacheConfiguration defaultCacheConfiguration = new CacheConfiguration().persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP)).timeToIdleSeconds(config.getTimeToIdle()).timeToLiveSeconds(config.getTimeToLive());
            defaultCacheConfiguration.setMaxBytesLocalDisk(Long.valueOf(config.getDiskCacheSize()));
            defaultCacheConfiguration.setMaxBytesLocalHeap(Long.valueOf(config.getHeapSize()));
            cacheConfig.defaultCache(defaultCacheConfiguration);
        }
        CacheManager manager = CacheManager.create((Configuration)cacheConfig);
        if (removeCacheIfExists && manager.cacheExists(DEFAULT_CACHE)) {
            manager.removeCache(DEFAULT_CACHE);
            CacheManagement.logger().info("Re-creating cache default_cache");
        }
        if (!manager.cacheExists(DEFAULT_CACHE)) {
            manager.addCache(DEFAULT_CACHE);
        }
        Cache cache = manager.getCache(DEFAULT_CACHE);
        SelfPopulatingCache populatingCache = new SelfPopulatingCache((Ehcache)cache, (CacheEntryFactory)new S3ChunkEntryFactory(config));
        manager.replaceCacheWithDecoratedCache((Ehcache)cache, (Ehcache)populatingCache);
        return manager;
    }

    private static Configuration loadConfiguration(String configFile) {
        try {
            CacheManagement.logger().info("Loading s3-geotiff cache configuration from " + configFile);
            return ConfigurationFactory.parseConfiguration((File)new File(configFile));
        }
        catch (Exception e) {
            CacheManagement.logger().log(Level.WARNING, String.format("Unable to configure S3 GeoTiff cache from %s, using default config", configFile), e);
            return null;
        }
    }

    private static Logger logger() {
        return Logging.getLogger((String)"org.geotools.s3.cache.CacheManagement");
    }

    public byte[] getChunk(CacheEntryKey key, S3Connector connector) {
        key.setConnector(connector);
        return (byte[])this.manager.getEhcache(DEFAULT_CACHE).get((Serializable)key).getObjectValue();
    }

    public CacheConfig getCacheConfig() {
        return this.config;
    }
}

