/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3.cache;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.loader.CacheLoader;
import org.geotools.s3.S3Connector;
import org.geotools.s3.cache.CacheConfig;
import org.geotools.s3.cache.CacheEntryKey;

public class S3ChunkEntryFactory
implements CacheEntryFactory,
CacheLoader {
    private static final Logger LOGGER = Logger.getLogger("S3");
    private int cacheBlockSize;

    public S3ChunkEntryFactory(CacheConfig config) {
        this.cacheBlockSize = config.getChunkSizeBytes();
    }

    public Object createEntry(Object key) throws Exception {
        return this.createEntry(key, ((CacheEntryKey)key).getConnector());
    }

    private Object createEntry(Object key, S3Connector connector) throws IOException {
        byte[] val;
        CacheEntryKey entryKey = (CacheEntryKey)key;
        byte[] buffer = new byte[this.cacheBlockSize];
        try (S3Object object = this.initStream((long)entryKey.getBlock() * (long)this.cacheBlockSize, entryKey.getBucket(), entryKey.getKey(), entryKey.getBlockSize(), connector.getS3Client());){
            if (object == null) {
                throw new RuntimeException("Unable to instantiate S3 stream. See logs for details.");
            }
            try (S3ObjectInputStream stream = object.getObjectContent();
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int nBytes;
                for (int readLength = this.cacheBlockSize; readLength > 0 && (nBytes = stream.read(buffer, 0, readLength)) > 0; readLength -= nBytes) {
                    out.write(buffer, 0, nBytes);
                }
                val = out.toByteArray();
            }
        }
        return val;
    }

    private S3Object initStream(long offset, String bucket, String key, int blockSize, AmazonS3 s3Client) {
        try {
            S3Object object = s3Client.getObject(new GetObjectRequest(bucket, key).withRange(offset, offset + (long)blockSize));
            return object;
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            return null;
        }
    }

    public Object load(Object key) throws CacheException {
        throw new UnsupportedOperationException("Can't load chunk without loader argument.");
    }

    public Map loadAll(Collection keys) {
        throw new UnsupportedOperationException("Can't load chunk without loader argument.");
    }

    public Object load(Object key, Object argument) {
        S3Connector connector = (S3Connector)argument;
        try {
            return this.createEntry(key, connector);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception creating entry for key: " + key, e);
            throw new RuntimeException("Exception creating entry for key: " + key);
        }
    }

    public Map loadAll(Collection keys, Object argument) {
        throw new UnsupportedOperationException("Can't load chunk without loader argument.");
    }

    public String getName() {
        return "S3ChunkEntryFactory";
    }

    public CacheLoader clone(Ehcache cache) throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Can't load chunk without loader argument.");
    }

    public void init() {
    }

    public void dispose() throws CacheException {
    }

    public Status getStatus() {
        return null;
    }
}

