/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import javax.imageio.stream.ImageInputStreamImpl;
import org.geotools.s3.S3Connector;
import org.geotools.s3.cache.CacheEntryKey;
import org.geotools.s3.cache.CacheManagement;

public class S3ImageInputStreamImpl
extends ImageInputStreamImpl {
    private final String fileName;
    private final S3Connector connector;
    private String url;
    private String bucket;
    private String key;
    private AmazonS3 s3;
    private long length;
    private int cacheBlockSize;

    private AmazonS3 getS3Client() {
        if (this.s3 == null) {
            this.s3 = this.connector.getS3Client();
        }
        return this.s3;
    }

    public S3ImageInputStreamImpl(URL input) throws IOException {
        this(input.toString());
    }

    public S3ImageInputStreamImpl(String input) throws IOException {
        this.connector = new S3Connector(input);
        this.url = input;
        String urlWithoutQueryString = input.split("\\?")[0];
        String[] parts = urlWithoutQueryString.split("/");
        if (input.startsWith("http")) {
            this.bucket = parts[parts.length - 2];
            this.key = parts[parts.length - 1];
        } else {
            StringBuilder keyBuilder = new StringBuilder();
            this.bucket = parts[2];
            for (int i = 3; i < parts.length; ++i) {
                keyBuilder.append("/").append(URLDecoder.decode(parts[i], "UTF-8"));
            }
            this.key = keyBuilder.toString();
            this.key = this.key.startsWith("/") ? this.key.substring(1) : this.key;
        }
        AmazonS3 s3Client = this.getS3Client();
        ObjectMetadata meta = s3Client.getObjectMetadata(new GetObjectMetadataRequest(this.bucket, this.key));
        this.length = meta.getContentLength();
        this.fileName = this.nameFromKey(this.key);
        this.cacheBlockSize = CacheManagement.DEFAULT.getCacheConfig().getChunkSizeBytes();
    }

    private String nameFromKey(String key) {
        String[] parts = key.split("/");
        return parts[parts.length - 1];
    }

    private byte[] getFromCache(int block) throws IOException {
        int blockSizeForBlock = this.calculateBlockSizeForBlock(block);
        CacheEntryKey keyForBlock = new CacheEntryKey(this.bucket, this.key, block, blockSizeForBlock);
        return CacheManagement.DEFAULT.getChunk(keyForBlock, this.connector);
    }

    private int calculateBlockSizeForBlock(int block) {
        long offsetInFile = this.cacheBlockSize * block;
        long remainingInFile = this.length - offsetInFile;
        return (int)Math.min((long)this.cacheBlockSize, remainingInFile);
    }

    private byte readFromCache(int block, int offset) {
        try {
            byte[] byteBlock = this.getFromCache(block);
            return byteBlock[offset];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        byte rawValue = this.readRawValue();
        return Byte.toUnsignedInt(rawValue);
    }

    private byte readRawValue() {
        int block = this.getBlockIndex();
        int offset = this.getCurrentOffset();
        byte rawValue = this.readFromCache(block, offset);
        ++this.streamPos;
        return rawValue;
    }

    private int getCurrentOffset() {
        return (int)(this.streamPos % (long)this.cacheBlockSize);
    }

    @Override
    public int read(byte[] targetBuffer, int off, int len) throws IOException {
        int readRemaining = len;
        ByteBuffer readBuffer = ByteBuffer.allocate(len);
        while (readRemaining > 0 && this.streamPos < this.length) {
            int block = this.getBlockIndex();
            int offset = this.getCurrentOffset();
            byte[] blockBytes = this.getFromCache(block);
            int bytesToRead = Math.min(readRemaining, blockBytes.length - offset);
            readBuffer.put(blockBytes, offset, bytesToRead);
            readRemaining -= bytesToRead;
            this.streamPos += (long)bytesToRead;
        }
        ByteBuffer inputByteBuffer = ByteBuffer.wrap(targetBuffer, off, len);
        inputByteBuffer.put(readBuffer.array(), 0, len);
        return len - readRemaining;
    }

    private int getBlockIndex() {
        return (int)Math.floor((double)this.streamPos / (double)this.cacheBlockSize);
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("readLine NOT Supported");
    }

    String getUrl() {
        return this.url;
    }

    public String getFileName() {
        return this.fileName;
    }
}

