/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3.cache;

import java.io.Serializable;
import org.geotools.s3.S3Connector;

public class CacheEntryKey
implements Serializable {
    private String bucket;
    private String key;
    private int block;
    private int blockSize;
    private transient S3Connector connector;

    public CacheEntryKey(String bucket, String key, int block, int blockSize) {
        this.bucket = bucket;
        this.key = key;
        this.block = block;
        this.blockSize = blockSize;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public int getBlock() {
        return this.block;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        return String.format("CacheEntry[bucket: %s, key %s, block: %d, blockSize: %d]", this.bucket, this.key, this.block, this.blockSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntryKey that = (CacheEntryKey)o;
        if (this.block != that.block) {
            return false;
        }
        if (this.blockSize != that.blockSize) {
            return false;
        }
        if (!this.bucket.equals(that.bucket)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.block;
        result = 31 * result + this.blockSize;
        return result;
    }

    public S3Connector getConnector() {
        return this.connector;
    }

    public void setConnector(S3Connector connector) {
        this.connector = connector;
    }
}

