/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.geotools.s3.S3ImageInputStreamImpl;

public class S3ImageInputStreamImplSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input.s3");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class<String> inputClass = String.class;

    public S3ImageInputStreamImplSpi() {
        super(vendorName, version, inputClass);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider that wraps a file in S3";
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        super.onRegistration(registry, category);
        Class<ImageInputStreamSpi> targetClass = ImageInputStreamSpi.class;
        Iterator<ImageInputStreamSpi> i = registry.getServiceProviders(targetClass, true);
        while (i.hasNext()) {
            ImageInputStreamSpi other = i.next();
            if (this == other) continue;
            registry.setOrdering(targetClass, this, other);
        }
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("S3ImageInputStreamImplSpi.createInputStreamInstance(" + String.valueOf(input.getClass()) + ")");
        }
        if (input instanceof S3ImageInputStreamImpl) {
            try {
                return new S3ImageInputStreamImpl(((S3ImageInputStreamImpl)input).getUrl());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            String path = (String)input;
            return new S3ImageInputStreamImpl(path);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }
}

