/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.S3ClientOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.geotools.s3.S3Utils;

public class S3Connector {
    private static final Logger LOGGER = Logger.getLogger(S3Utils.class.getName());
    public static final String S3_GEOTIFF_CONFIG_PATH = "s3.properties.location";
    private Properties prop;
    private String url;
    private String regionString;
    private boolean useAnon = false;

    public S3Connector(String regionString, boolean useAnon) {
        this.regionString = regionString;
        this.useAnon = useAnon;
    }

    S3Connector(String input) {
        this.url = input;
        try {
            URI s3Uri = new URI(input);
            List nameValuePairs = URLEncodedUtils.parse((URI)s3Uri, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair nvPair : nameValuePairs) {
                if ("awsRegion".equals(nvPair.getName())) {
                    this.regionString = nvPair.getValue();
                }
                if (!"useAnon".equals(nvPair.getName())) continue;
                this.useAnon = Boolean.parseBoolean(nvPair.getValue());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.finer("Error parsing S3 URL in order to parse query options");
        }
    }

    public AmazonS3 getS3Client() {
        AmazonS3 s3;
        Regions region;
        if (this.regionString != null) {
            try {
                region = Regions.valueOf((String)this.regionString);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("AWS_REGION property is set, but not set correctly. Check that the AWS_REGION property matches the Regions enum");
                region = Regions.US_EAST_1;
            }
        } else {
            LOGGER.warning("No AWS_REGION property set, defaulting to US_EAST_1");
            region = Regions.US_EAST_1;
        }
        if (this.url != null && !this.url.startsWith("s3://")) {
            if (!this.url.contains("://")) {
                throw new IllegalArgumentException("Following this style: s3Alias://bucket/filename");
            }
            String s3Alias = this.url.split("://")[0];
            Properties prop = this.readProperties(s3Alias);
            s3 = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(prop.getProperty(s3Alias + ".s3.user"), prop.getProperty(s3Alias + ".s3.password"))))).build();
            S3ClientOptions clientOptions = S3ClientOptions.builder().setPathStyleAccess(true).build();
            s3.setS3ClientOptions(clientOptions);
            Object endpoint = prop.getProperty(s3Alias + ".s3.endpoint");
            if (!((String)endpoint).endsWith("/")) {
                endpoint = (String)endpoint + "/";
            }
            s3.setEndpoint((String)endpoint);
        } else {
            s3 = this.useAnon ? (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).withRegion(region)).build() : (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).build();
        }
        return s3;
    }

    public static String[] getS3PathParts(String s3Path) {
        String[] parts = s3Path.split("/");
        StringBuilder keyBuilder = new StringBuilder();
        String bucket = parts[2];
        for (int i = 3; i < parts.length; ++i) {
            keyBuilder.append("/").append(parts[i]);
        }
        String key = keyBuilder.toString();
        key = key.startsWith("/") ? key.substring(1) : key;
        return new String[]{bucket, key};
    }

    private Properties readProperties(String s3Alias) {
        try {
            if (this.prop == null) {
                String property = System.getProperty(S3_GEOTIFF_CONFIG_PATH);
                if (property != null) {
                    this.prop = new Properties();
                    try (FileInputStream resourceAsStream = new FileInputStream(property);){
                        this.prop.load(resourceAsStream);
                    }
                } else {
                    throw new IOException("Properties are missing! The system property 's3.properties.location' should be set and contain the path to the s3.properties file.");
                }
            }
            if (this.prop.getProperty(s3Alias + ".s3.user") == null) {
                throw new IllegalArgumentException("s3.properties file does not contains value for:" + s3Alias + ".s3.user");
            }
            if (this.prop.getProperty(s3Alias + ".s3.password") == null) {
                throw new IllegalArgumentException("s3.properties file does not contains value for:" + s3Alias + ".s3.password");
            }
            if (this.prop.getProperty(s3Alias + ".s3.endpoint") == null) {
                throw new IllegalArgumentException("s3.properties file does not contains value for:" + s3Alias + ".s3.endpoint");
            }
        }
        catch (IOException ex) {
            LOGGER.severe(ex.getMessage());
            throw new IllegalArgumentException("The properties could not be found.", ex);
        }
        return this.prop;
    }
}

