/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.net.URL;
import javax.swing.Icon;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.ows.MockURLChecker;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.data.ows.URLCheckers;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageGraphicFactoryTest {
    private ImageGraphicFactory image;
    private FilterFactory ff;

    @Before
    public void setUp() throws Exception {
        this.image = new ImageGraphicFactory();
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @After
    public void cleanupCheckers() {
        URLCheckers.reset();
    }

    @Test
    public void testFormats() throws Exception {
        Assert.assertTrue((boolean)this.image.getSupportedMimeTypes().contains("image/png"));
        Assert.assertTrue((boolean)this.image.getSupportedMimeTypes().contains("image/jpeg"));
    }

    @Test
    public void testInvalidPaths() throws Exception {
        Assert.assertNull((Object)this.image.getIcon(null, (Expression)this.ff.literal((Object)"http://www.nowhere.com"), "image/not!", 20));
        try {
            this.image.getIcon(null, (Expression)this.ff.literal((Object)"ThisIsNotAUrl"), "image/png", 20);
            Assert.fail((String)"Should have throw an exception, invalid url");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalURL() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/draw.png");
        Assert.assertNotNull((Object)url);
        Icon icon = this.image.getIcon(null, (Expression)this.ff.literal((Object)url), "image/png", 80);
        Assert.assertNotNull((Object)icon);
        Assert.assertEquals((long)80L, (long)icon.getIconHeight());
    }

    @Test
    public void testNaturalSize() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/draw.png");
        Assert.assertNotNull((Object)url);
        Icon icon = this.image.getIcon(null, (Expression)this.ff.literal((Object)url), "image/png", -1);
        Assert.assertNotNull((Object)icon);
        Assert.assertEquals((long)22L, (long)icon.getIconHeight());
    }

    @Test
    public void testClearCache() {
        URL u = this.getClass().getResource("test-data/test.png");
        this.image.getIcon(null, (Expression)this.ff.literal((Object)u), "image/png", -1);
        Assert.assertTrue((boolean)ImageGraphicFactory.imageCache.containsKey(u));
        Assert.assertNotNull(ImageGraphicFactory.imageCache.get(u));
        this.image.clearCache();
        Assert.assertTrue((boolean)ImageGraphicFactory.imageCache.isEmpty());
    }

    @Test
    public void testURLCheckerAllowed() throws Exception {
        URLCheckers.register((URLChecker)new MockURLChecker(u -> u.contains("test.png")));
        URL u2 = this.getClass().getResource("test-data/test.png");
        Assert.assertNotNull((Object)this.image.getIcon(null, (Expression)this.ff.literal((Object)u2), "image/png", -1));
    }

    @Test
    public void testURLCheckerDisallowed() throws Exception {
        URLCheckers.register((URLChecker)new MockURLChecker("nope", u -> false));
        URL u2 = this.getClass().getResource("test-data/test.png");
        Assert.assertThrows(URLCheckerException.class, () -> this.image.getIcon(null, (Expression)this.ff.literal((Object)u2), "image/png", -1));
    }
}

