/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.geotools.renderer.lite.StreamingRendererTest;
import org.geotools.renderer.style.FontCache;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FontCacheTest {
    @After
    public void cleanCache() {
        FontCache.getDefaultInstance().resetCache();
    }

    @Test
    public void testUnregisterdAlternatives() {
        FontCache fc = FontCache.getDefaultInstance();
        Assume.assumeThat((Object)fc.getAvailableFonts(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.startsWith((String)"Droid"))));
        List alternatives = fc.getAlternatives("Droid");
        MatcherAssert.assertThat((Object)alternatives, (Matcher)Matchers.empty());
    }

    @Test
    public void testManualAlternatives() {
        FontCache fc = FontCache.getDefaultInstance();
        fc.registerFont(this.loadFont("DroidSansArmenian.ttf"));
        fc.registerFont(this.loadFont("DroidSansFallback.ttf"));
        fc.registerFont(this.loadFont("DroidNaskh-Regular.ttf"));
        List alternatives = fc.getAlternatives("Droid");
        MatcherAssert.assertThat((Object)alternatives, (Matcher)Matchers.hasItems((Object[])new String[]{"Droid Arabic Naskh", "Droid Sans Armenian", "Droid Sans Fallback"}));
    }

    private Font loadFont(String fontName) {
        return FontCache.loadFromUrl((String)StreamingRendererTest.class.getResource("test-data/" + fontName).toExternalForm());
    }

    @Test
    public void testFontAlternatives() {
        String baseName = "Noto Sans";
        ArrayList alternatives = new ArrayList();
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Regular", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Arabic Regular", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Arabic Black", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Arabic SemiBold", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans SemiBold", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Armenian", alternatives);
        FontCache.collectAlternative((String)baseName, (String)"Noto Sans Armenian Thin", alternatives);
        List<String> expected = List.of("Noto Sans Regular", "Noto Sans Arabic Regular", "Noto Sans Armenian");
        Assert.assertEquals(expected, alternatives);
    }
}

