/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionExtractorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testLiteral() {
        String exp = "I'm a plain string";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.ff.literal((Object)"I'm a plain string"), result.get(0));
    }

    @Test
    public void testLiteralEscapes() {
        String exp = "I'm a plain string \\\\ \\${bla bla\\}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string \\\\ \\${bla bla\\}");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.ff.literal((Object)"I'm a plain string \\ ${bla bla}"), result.get(0));
    }

    @Test
    public void testSimpleExpressions() {
        String exp = "I'm a ${name} expression of type ${type}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a ${name} expression of type ${type}");
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)this.ff.literal((Object)"I'm a "), result.get(0));
        Assert.assertEquals((Object)this.ff.property("name"), result.get(1));
        Assert.assertEquals((Object)this.ff.literal((Object)" expression of type "), result.get(2));
        Assert.assertEquals((Object)this.ff.property("type"), result.get(3));
    }

    @Test
    public void testDoubleOpen() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla ${bla}");
            Assert.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenLingering() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla");
            Assert.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleClose() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla}}");
            Assert.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEscapesInside() {
        String exp = "${strLength('\\\\\\${\\}')}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"${strLength('\\\\\\${\\}')}");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.ff.function("strLength", new Expression[]{this.ff.literal((Object)"\\${}")}), result.get(0));
    }

    @Test
    public void testTwoExpressions() {
        String exp = "${name}${age}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"${name}${age}");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)this.ff.property("name"), result.get(0));
        Assert.assertEquals((Object)this.ff.property("age"), result.get(1));
    }

    @Test
    public void testCatenateOne() {
        Literal l = this.ff.literal((Object)"http://test?param=");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l));
        Assert.assertEquals((Object)l, (Object)cat);
    }

    @Test
    public void testCatenateTwo() {
        Literal l = this.ff.literal((Object)"http://test?param=");
        PropertyName pn = this.ff.property("intAttribute");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l, pn));
        Assert.assertTrue((boolean)(cat instanceof Function));
        Function f = (Function)cat;
        Assert.assertEquals((Object)"Concatenate", (Object)f.getName());
        Assert.assertEquals((Object)l, f.getParameters().get(0));
        Assert.assertEquals((Object)pn, f.getParameters().get(1));
    }

    @Test
    public void testCatenateThree() {
        Literal l1 = this.ff.literal((Object)"http://test?param=");
        PropertyName pn = this.ff.property("intAttribute");
        Literal l2 = this.ff.literal((Object)"&param2=foo");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l1, pn, l2));
        Assert.assertTrue((boolean)(cat instanceof Function));
        Function f = (Function)cat;
        Assert.assertEquals((Object)"Concatenate", (Object)f.getName());
        Assert.assertEquals((Object)l1, f.getParameters().get(0));
        Assert.assertEquals((Object)pn, f.getParameters().get(1));
        Assert.assertEquals((Object)l2, f.getParameters().get(2));
    }

    @Test
    public void testCacheResults() throws Exception {
        String exp = "I'm a ${name} expression of type ${type}";
        Expression ex1 = ExpressionExtractor.extractCqlExpressions((String)"I'm a ${name} expression of type ${type}");
        Expression ex2 = ExpressionExtractor.extractCqlExpressions((String)"I'm a ${name} expression of type ${type}");
        Assert.assertSame((Object)ex1, (Object)ex2);
        ExpressionExtractor.cleanExpressionCache();
        Expression ex3 = ExpressionExtractor.extractCqlExpressions((String)"I'm a ${name} expression of type ${type}");
        Assert.assertNotSame((Object)ex1, (Object)ex3);
    }
}

