/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ExtremaDescriptor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormatFactory;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.test.TestData;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xml.styling.SLDParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TransparencyStyledTest {
    private static final StyleFactory SF = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());

    private GridCoverage2D readCoverage(File mosaicDirectory, FootprintBehavior fp, Color transparentColor) throws NoSuchAuthorityCodeException, FactoryException, IOException {
        ImageMosaicReader reader = (ImageMosaicReader)new ImageMosaicFormatFactory().createFormat().getReader((Object)mosaicDirectory);
        ParameterValue footprintBehaviorParam = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintBehaviorParam.setValue((Object)fp.name());
        ParameterValue inputTransparentColor = AbstractGridFormat.INPUT_TRANSPARENT_COLOR.createValue();
        inputTransparentColor.setValue((Object)transparentColor);
        GeneralParameterValue[] readParams = new GeneralParameterValue[]{footprintBehaviorParam, inputTransparentColor};
        GridCoverage2D coverage = reader.read(readParams);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        return coverage;
    }

    private void disposeCoverage(GridCoverage2D coverage) {
        if (coverage == null) {
            return;
        }
        RenderedImage im = coverage.getRenderedImage();
        ImageUtilities.disposePlanarImageChain((PlanarImage)PlanarImage.wrapRenderedImage((RenderedImage)im));
        coverage.dispose(true);
    }

    @AfterClass
    public static void close() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @BeforeClass
    public static void init() {
        CRS.reset((String)"all");
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    @Test
    public void testTransparentFootprintWithContrastEnhancementInChannelSelect() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("footprintCECS");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.Transparent, null);
        RenderedImage ri = gc.getRenderedImage();
        RenderedOp extrema = ExtremaDescriptor.create((RenderedImage)ri, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        double[] minimum = (double[])extrema.getProperty("minimum");
        double[] maximum = (double[])extrema.getProperty("maximum");
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double[])minimum, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{54.0, 54.0, 54.0, 255.0}, (double[])maximum, (double)1.0E-6);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "ce_cs.sld");
        ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        extrema = ExtremaDescriptor.create((RenderedImage)ri, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        minimum = (double[])extrema.getProperty("minimum");
        maximum = (double[])extrema.getProperty("maximum");
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double[])minimum, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{255.0, 255.0, 255.0, 255.0}, (double[])maximum, (double)1.0E-6);
        this.disposeCoverage(output);
        ImageUtilities.disposePlanarImageChain((PlanarImage)extrema);
    }

    @Test
    public void testTransparentColorWithContrastEnhancementInChannelSelect() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("transparentCECS");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.None, Color.BLACK);
        RenderedImage ri = gc.getRenderedImage();
        RenderedOp extrema = ExtremaDescriptor.create((RenderedImage)ri, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        double[] minimum = (double[])extrema.getProperty("minimum");
        double[] maximum = (double[])extrema.getProperty("maximum");
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double[])minimum, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{54.0, 54.0, 54.0, 255.0}, (double[])maximum, (double)1.0E-6);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "ce_cs.sld");
        ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        extrema = ExtremaDescriptor.create((RenderedImage)ri, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        minimum = (double[])extrema.getProperty("minimum");
        maximum = (double[])extrema.getProperty("maximum");
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double[])minimum, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{255.0, 255.0, 255.0, 255.0}, (double[])maximum, (double)1.0E-6);
        this.disposeCoverage(output);
        ImageUtilities.disposePlanarImageChain((PlanarImage)extrema);
    }

    @Test
    public void testRGBAWithContrastEnhancementInChannelSelect() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.file((Object)this, (String)"map.tif"));
        GridCoverage2D gc = reader.read(null);
        RenderedImage ri = gc.getRenderedImage();
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "ce_cs.sld");
        ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        this.disposeCoverage(output);
    }

    @Test
    public void testTransparentFootprintWithChannelSelectRGB() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("footprintCS");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.Transparent, null);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "channelselect.sld");
        RenderedImage ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        this.disposeCoverage(output);
    }

    @Test
    public void testTransparentColorWithChannelSelectRGB() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("transparentCS");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.None, Color.BLACK);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "channelselect.sld");
        RenderedImage ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        this.disposeCoverage(output);
    }

    @Test
    public void testTransparentFootprintWithChannelSelectColormap() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("footprintCSCM");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.Transparent, null);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "graychannelcolormap.sld");
        RenderedImage ri = output.getRenderedImage();
        this.assertHasAlpha(ri);
        this.disposeCoverage(output);
    }

    @Test
    public void testTransparentFootprintWithChannelSelectGray() throws IOException, NoSuchAuthorityCodeException, FactoryException {
        File mosaicDirectory = this.prepareDirectory("footprintCSGray");
        GridCoverage2D gc = this.readCoverage(mosaicDirectory, FootprintBehavior.Transparent, null);
        GridCoverage2D output = (GridCoverage2D)this.symbolizeRaster(gc, "graychannel.sld");
        RenderedImage ri = output.getRenderedImage();
        ColorModel cm = ri.getColorModel();
        Assert.assertTrue((boolean)cm.hasAlpha());
        Assert.assertEquals((long)2L, (long)cm.getNumComponents());
        Raster rasterPixel = ri.getData(new Rectangle(0, 0, 1, 1));
        Assert.assertEquals((long)0L, (long)rasterPixel.getSample(0, 0, 1));
        this.disposeCoverage(output);
    }

    private File prepareDirectory(String subDirectory) throws IOException {
        File source = TestData.file((Object)this, (String)"masked3");
        File testDataDir = TestData.file((Object)this, (String)".");
        File mosaicDirectory = new File(testDataDir, subDirectory);
        if (mosaicDirectory.exists()) {
            FileUtils.deleteDirectory((File)mosaicDirectory);
        }
        FileUtils.copyDirectory((File)source, (File)mosaicDirectory);
        for (File file : FileUtils.listFiles((File)mosaicDirectory, (IOFileFilter)new SuffixFileFilter(".sld"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        return mosaicDirectory;
    }

    private static RasterSymbolizer extractRasterSymbolizer(StyledLayerDescriptor sld) {
        UserLayer nl = (UserLayer)sld.getStyledLayers()[0];
        Style style = nl.getUserStyles()[0];
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Rule rule = (Rule)fts.rules().get(0);
        RasterSymbolizer rs_1 = (RasterSymbolizer)rule.symbolizers().get(0);
        return rs_1;
    }

    private GridCoverage symbolizeRaster(GridCoverage2D gc, String style) throws IOException {
        URL styleUrl = TestData.url((Object)this, (String)("masked3/" + style));
        SLDParser stylereader = new SLDParser(SF, styleUrl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper visitor = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = TransparencyStyledTest.extractRasterSymbolizer(sld);
        visitor.visit(rs);
        return visitor.getOutput();
    }

    private void assertHasAlpha(RenderedImage ri) {
        ColorModel cm = ri.getColorModel();
        Assert.assertTrue((boolean)cm.hasAlpha());
        int numComponents = cm.getNumComponents();
        Assert.assertEquals((long)4L, (long)numComponents);
        Raster raster = ri.getTile(0, 0);
        if (cm instanceof ComponentColorModel) {
            Assert.assertEquals((long)0L, (long)raster.getSample(0, 0, numComponents - 1));
        } else if (cm instanceof IndexColorModel) {
            int transparentPixel = ((IndexColorModel)cm).getTransparentPixel();
            Assert.assertEquals((long)transparentPixel, (long)raster.getSample(0, 0, 0));
        }
    }
}

