/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.media.jai.Interpolation;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Symbolizer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.image.WorldImageReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.GridCoverageRendererTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.StyleBuilder;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class GridCoverageRenderingOutOfViewTest {
    private final String rasterBase = "test_raster_NZTM";

    @Test
    public void test() throws IOException, URISyntaxException, MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException {
        StreamingRenderer renderer = new StreamingRenderer();
        MapContent map = new MapContent();
        URL raster = this.getClass().getResource("test_raster_NZTM.png");
        GridCoverage2D gc = this.readGeoReferencedImageFile(new File(raster.toURI()));
        map.addLayer(this.loadGeoReferencedImageFile(gc, "test"));
        renderer.setMapContent(map);
        BufferedImage image = new BufferedImage(400, 300, 2);
        Envelope env = new Envelope(1880352.0, 5825436.0, 1884352.0, 5828436.0);
        ReferencedEnvelope refenv = new ReferencedEnvelope(env, gc.getCoordinateReferenceSystem());
        final AtomicReference error = new AtomicReference();
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                error.set(e);
            }
        });
        renderer.paint(image.createGraphics(), new Rectangle(400, 300), refenv);
        map.dispose();
        Assert.assertNull(error.get());
    }

    @Test
    public void testOversamplingOnLayoutHelperArithmetic() throws Exception {
        RasterSymbolizerImpl rasterSymbolizer;
        AffineTransform w2s;
        Rectangle screenSize;
        ReferencedEnvelope mapExtent;
        URL coverageFile = TestData.url(GridCoverageRendererTest.class, (String)"arithmetic.tif");
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        GridCoverage2D coverage = reader.read(null);
        CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
        GridCoverageRenderer renderer = new GridCoverageRenderer(crs, (Envelope)(mapExtent = new ReferencedEnvelope(244897.2157599071, 244897.2203125144, 202588.4763366661, 202588.4808892734, crs)), screenSize = new Rectangle(0, 0, 200, 200), w2s = new AffineTransform(43930.870040629205, 0.0, 0.0, -43930.870040629205, -1.0758547758860409E10, 8.899888225675163E9));
        RenderedImage rendered = renderer.renderImage(coverage, (RasterSymbolizer)(rasterSymbolizer = new RasterSymbolizerImpl()), Interpolation.getInstance((int)0), Color.RED, 200, 200);
        Assert.assertTrue((rendered.getWidth() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((rendered.getHeight() > 0 ? 1 : 0) != 0);
        coverage.dispose(true);
    }

    public Layer loadGeoReferencedImageFile(GridCoverage2D gc, String title) throws IOException, URISyntaxException {
        StyleBuilder sb = new StyleBuilder();
        RasterSymbolizer rs = sb.createRasterSymbolizer();
        return new GridCoverageLayer(gc, sb.createStyle((Symbolizer)rs), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D readGeoReferencedImageFile(File f) throws IOException {
        WorldImageReader reader = null;
        try {
            reader = new WorldImageReader((Object)f);
            GridCoverage2D gridCoverage2D = reader.read(null);
            return gridCoverage2D;
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

