/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.media.jai.Interpolation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.geotools.TestData;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.lite.GridCoverageRendererTest;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GridCoverageReaderHelperTest {
    @Rule
    public TemporaryFolder crsMosaicFolder = new TemporaryFolder();
    static final double EPS = 1.0E-9;
    private GeoTiffReader reader;
    File coverageFile;

    @Before
    public void getData() throws IOException {
        MapProjection.SKIP_SANITY_CHECKS = true;
        this.coverageFile = TestData.copy((Object)this, (String)"geotiff/world.tiff");
        Assert.assertTrue((boolean)this.coverageFile.exists());
        this.reader = new GeoTiffReader((Object)this.coverageFile);
    }

    @After
    public void close() {
        MapProjection.SKIP_SANITY_CHECKS = false;
        this.reader.dispose();
    }

    @Test
    public void testGeographicLarge() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-360.0, 360.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(720, 180), mapExtent, Interpolation.getInstance((int)0));
        GridCoverage2D coverage = helper.readCoverage(null);
        ReferencedEnvelope envelope = coverage.getEnvelope2D();
        Assert.assertEquals((double)-180.0, (double)envelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)180.0, (double)envelope.getMaxX(), (double)1.0E-9);
        Assert.assertEquals((double)-90.0, (double)envelope.getMinY(), (double)1.0E-9);
        Assert.assertEquals((double)90.0, (double)envelope.getMaxY(), (double)1.0E-9);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertEquals((long)1L, (long)coverages.size());
        Assert.assertEquals((Object)envelope, (Object)((GridCoverage2D)coverages.get(0)).getEnvelope2D());
    }

    @Test
    public void testGeographicLargeAccurateResolutionFlags() throws Exception {
        String testLocation = "geographicLarge";
        URL storeUrl = TestData.url((Object)this, (String)"geotiff/world.tiff");
        File testData = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyFileToDirectory((File)testData, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-180.0, 180.0, -80.0, 80.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope requestedEnvelope = mapExtent.transform(targetCRS, true);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(90, 40), requestedEnvelope, Interpolation.getInstance((int)0));
        MathTransform originalG2W = imReader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        AffineTransform at = (AffineTransform)originalG2W;
        double originalResolution = 0.9;
        Assert.assertEquals((double)Math.abs(at.getScaleX()), (double)0.9, (double)1.0E-9);
        Assert.assertEquals((double)Math.abs(at.getScaleY()), (double)0.9, (double)1.0E-9);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        at = (AffineTransform)((GridCoverage2D)coverages.get(0)).getGridGeometry().getGridToCRS();
        Assert.assertTrue((Math.abs(at.getScaleX()) <= 0.9 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(at.getScaleY()) <= 0.9 ? 1 : 0) != 0);
        ParameterValue accurateResolution = ImageMosaicFormat.ACCURATE_RESOLUTION.createValue();
        accurateResolution.setValue(false);
        coverages = helper.readCoverages(new GeneralParameterValue[]{accurateResolution}, handler);
        at = (AffineTransform)((GridCoverage2D)coverages.get(0)).getGridGeometry().getGridToCRS();
        Assert.assertTrue((Math.abs(at.getScaleX()) > 2.7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(at.getScaleY()) > 2.7 ? 1 : 0) != 0);
    }

    @Test
    public void testGeographicDatelineCross() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(170.0, 190.0, 70.0, 80.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(100, 100), mapExtent, Interpolation.getInstance((int)0));
        GridCoverage2D coverage = helper.readCoverage(null);
        ReferencedEnvelope envelope = coverage.getEnvelope2D();
        Assert.assertEquals((double)-180.0, (double)envelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)180.0, (double)envelope.getMaxX(), (double)1.0E-9);
        Assert.assertEquals((double)-90.0, (double)envelope.getMinY(), (double)1.0E-9);
        Assert.assertEquals((double)90.0, (double)envelope.getMaxY(), (double)1.0E-9);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertEquals((long)2L, (long)coverages.size());
        ReferencedEnvelope firstEnvelope = ((GridCoverage2D)coverages.get(0)).getEnvelope2D();
        Assert.assertEquals((double)169.2, (double)firstEnvelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)180.0, (double)firstEnvelope.getMaxX(), (double)1.0E-9);
        Assert.assertEquals((double)69.3, (double)firstEnvelope.getMinY(), (double)1.0E-9);
        Assert.assertEquals((double)80.1, (double)firstEnvelope.getMaxY(), (double)1.0E-9);
        ReferencedEnvelope secondEnvelope = ((GridCoverage2D)coverages.get(1)).getEnvelope2D();
        Assert.assertEquals((double)-180.0, (double)secondEnvelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)-169.2, (double)secondEnvelope.getMaxX(), (double)1.0E-9);
        Assert.assertEquals((double)69.3, (double)secondEnvelope.getMinY(), (double)1.0E-9);
        Assert.assertEquals((double)80.1, (double)secondEnvelope.getMaxY(), (double)1.0E-9);
    }

    @Test
    public void testUTM() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1.5E7, 1.5E7, 0.0, 1000000.0, crs);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(400, 200), mapExtent, Interpolation.getInstance((int)0));
        GridCoverage2D coverage = helper.readCoverage(null);
        ReferencedEnvelope envelope = coverage.getEnvelope2D();
        Assert.assertTrue((envelope.getMinX() < -100.0 ? 1 : 0) != 0);
        Assert.assertTrue((envelope.getMaxX() > 100.0 ? 1 : 0) != 0);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertEquals((long)1L, (long)coverages.size());
        envelope = ((GridCoverage2D)coverages.get(0)).getEnvelope2D();
        Assert.assertEquals((double)-36.0, (double)envelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)54.0, (double)envelope.getMaxX(), (double)1.0E-9);
    }

    @Test
    public void testConic() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1.5E7, 1.5E7, 0.0, 1000000.0, crs);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(400, 200), mapExtent, Interpolation.getInstance((int)0));
        GridCoverage2D coverage = helper.readCoverage(null);
        ReferencedEnvelope envelope = coverage.getEnvelope2D();
        Assert.assertTrue((envelope.getMinX() < -100.0 ? 1 : 0) != 0);
        Assert.assertTrue((envelope.getMaxX() > 100.0 ? 1 : 0) != 0);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertEquals((long)1L, (long)coverages.size());
        envelope = ((GridCoverage2D)coverages.get(0)).getEnvelope2D();
        Assert.assertEquals((double)-36.0, (double)envelope.getMinX(), (double)1.0E-9);
        Assert.assertEquals((double)54.0, (double)envelope.getMaxX(), (double)1.0E-9);
    }

    @Test
    public void testOutsideDefinitionArea() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1250000.0, 0.0, -1.375E7, -1.25E7, crs);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)this.reader, new Rectangle(400, 200), mapExtent, Interpolation.getInstance((int)0));
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertTrue((boolean)coverages.isEmpty());
    }

    @Test
    public void testFullResolutionNull() throws Exception {
        final GridCoverage2D coverage = new GridCoverageFactory().create((CharSequence)"test", new float[200][100], (Bounds)new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        AbstractGridCoverage2DReader reader = new AbstractGridCoverage2DReader(){
            {
                this.crs = DefaultGeographicCRS.WGS84;
                this.originalEnvelope = new GeneralBounds((Bounds)coverage.getEnvelope2D());
                this.originalGridRange = coverage.getGridGeometry().getGridRange();
            }

            public Format getFormat() {
                return null;
            }

            public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
                return coverage;
            }
        };
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2.0E7, 2.0E7, -2.0E7, 2.0E7, crs);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)reader, new Rectangle(400, 200), mapExtent, Interpolation.getInstance((int)0));
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapExtent, (CoordinateReferenceSystem)reader.getCoordinateReferenceSystem(), (boolean)true);
        List coverages = helper.readCoverages(null, handler);
        Assert.assertEquals((long)1L, (long)coverages.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCutUnreferenced() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)DefaultEngineeringCRS.GENERIC_2D);
        GeoTiffReader reader = null;
        try {
            reader = new GeoTiffReader((Object)this.coverageFile, hints);
            ReferencedEnvelope mapExtent = new ReferencedEnvelope(-90.0, 0.0, -45.0, 45.0, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
            GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)reader, new Rectangle(200, 200), mapExtent, Interpolation.getInstance((int)0));
            List coverages = helper.readCoverages(null, null);
            Assert.assertEquals((long)1L, (long)coverages.size());
            GridCoverage2D gc = (GridCoverage2D)coverages.get(0);
            Bounds envelope = gc.getEnvelope();
            Assert.assertEquals((double)-90.0, (double)envelope.getMinimum(0), (double)1.0E-9);
            Assert.assertEquals((double)0.0, (double)envelope.getMaximum(0), (double)1.0E-9);
            Assert.assertEquals((double)-45.0, (double)envelope.getMinimum(1), (double)1.0E-9);
            Assert.assertEquals((double)45.0, (double)envelope.getMaximum(1), (double)1.0E-9);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadResolution3003InvalidArea() throws Exception {
        this.coverageFile = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("test-data/test3003.tif"));
        Assert.assertTrue((boolean)this.coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)this.coverageFile);
        try {
            reader = new GeoTiffReader((Object)this.coverageFile);
            ReferencedEnvelope mapExtent = new ReferencedEnvelope(-130.0, -120.0, -40.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)reader, new Rectangle(200, 200), mapExtent, Interpolation.getInstance((int)0));
            ReferencedEnvelope readExtent = mapExtent.transform(reader.getCoordinateReferenceSystem(), true);
            Assert.assertFalse((boolean)helper.isAccurateResolutionComputationSafe(readExtent));
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (CoordinateReferenceSystem)reader.getCoordinateReferenceSystem(), (boolean)false);
            List coverages = helper.readCoverageInEnvelope(mapExtent, null, handler, true);
            Assert.assertNull((Object)coverages);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadOffDatelineBothSides() throws Exception {
        this.coverageFile = URLs.urlToFile((URL)this.getClass().getResource("test-data/off_dateline.tif"));
        Assert.assertTrue((boolean)this.coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)this.coverageFile);
        try {
            reader = new GeoTiffReader((Object)this.coverageFile);
            ReferencedEnvelope mapExtent = new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)reader, new Rectangle(1024, 512), mapExtent, Interpolation.getInstance((int)0));
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
            List coverages = helper.readCoverageInEnvelope(mapExtent, null, handler, true);
            Assert.assertEquals((long)1L, (long)coverages.size());
            GridCoverage2D coverage = (GridCoverage2D)coverages.get(0);
            ReferencedEnvelope envelope = coverage.getEnvelope2D();
            double EPS = 0.2;
            Assert.assertEquals((double)-180.4, (double)envelope.getMinX(), (double)0.2);
            Assert.assertEquals((double)2.0, (double)envelope.getMaxX(), (double)0.2);
            Assert.assertEquals((double)-90.0, (double)envelope.getMinY(), (double)0.2);
            Assert.assertEquals((double)90.0, (double)envelope.getMaxY(), (double)0.2);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    @Test
    public void testPaddingHeteroMosaic() throws Exception {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url(this.getClass(), (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)imReader, new Rectangle(1024, 512), mapExtent, Interpolation.getInstance((int)0));
        ReferencedEnvelope readEnvelope = helper.getReadEnvelope();
        double EPS = 0.001;
        Assert.assertEquals((double)10.981, (double)readEnvelope.getMinX(), (double)0.001);
        Assert.assertEquals((double)13.019, (double)readEnvelope.getMaxX(), (double)0.001);
        Assert.assertEquals((double)-1.039, (double)readEnvelope.getMinY(), (double)0.001);
        Assert.assertEquals((double)1.039, (double)readEnvelope.getMaxY(), (double)0.001);
    }

    @Test
    @Ignore
    public void testHarvestSpatialTwoReaders() throws Exception {
        File source = TestData.file(this.getClass(), (String)"red_footprint_test");
        File testDataDir = org.geotools.test.TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "redHarvest1");
        File directory2 = new File(testDataDir, "redHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("red[^3].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        ImageMosaicReader reader = new ImageMosaicReader((Object)directory1, null);
        ImageMosaicReader reader2 = new ImageMosaicReader((Object)directory1, null);
        for (File file : directory2.listFiles()) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
        }
        reader.harvest(null, (Object)directory1, null);
        ReferencedEnvelope readEnvelope = new ReferencedEnvelope(991000.0, 992000.0, 216000.0, 217000.0, reader2.getCoordinateReferenceSystem());
        Rectangle rasterArea = new Rectangle(0, 0, 10, 10);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper((GridCoverage2DReader)reader2, rasterArea, readEnvelope, null);
        ParameterValue ggParam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggParam.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(rasterArea), (Bounds)readEnvelope));
        GridCoverage2D coverage = helper.readCoverage(new GeneralParameterValue[]{ggParam});
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
        reader2.dispose();
    }
}

