/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ZOrderTest {
    private static final long TIME = 40000L;
    private static final int THRESHOLD = 100;
    SimpleFeatureSource zsquares;
    SimpleFeatureSource zroads;
    ReferencedEnvelope bounds;
    SimpleFeatureSource zbuildings;

    @Parameterized.Parameters
    public static Collection<Integer> maxMemorySortValues() {
        return Arrays.asList(1000, 2);
    }

    public ZOrderTest(Integer maxMemorySort) {
        Hints.putSystemDefault((RenderingHints.Key)Hints.MAX_MEMORY_SORT, (Object)maxMemorySort);
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"zorder/zsquares.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.zsquares = ds.getFeatureSource("zsquares");
        this.zroads = ds.getFeatureSource("zroads");
        this.zbuildings = ds.getFeatureSource("zbuildings");
        this.bounds = this.zsquares.getBounds();
        this.bounds.expandBy(0.2, 0.2);
    }

    @After
    public void tearDown() throws Exception {
        Hints.removeSystemDefault((RenderingHints.Key)Hints.MAX_MEMORY_SORT);
    }

    @Test
    public void testSingleZAscending() throws Exception {
        this.runZSquaresTest("zorder/zpolygon.sld", "z", "z-ascending");
    }

    @Test
    public void testSingleZDescending() throws Exception {
        this.runZSquaresTest("zorder/zpolygon.sld", "z D", "z-descending");
    }

    @Test
    public void testSingleCatDescendingZDescending() throws Exception {
        this.runZSquaresTest("zorder/zpolygon.sld", "cat D,z D", "cat-desc-z-desc");
    }

    @Test
    public void testSingleCatDescendingZAscending() throws Exception {
        this.runZSquaresTest("zorder/zpolygon.sld", "cat D,z A", "cat-desc-z-asc");
    }

    @Test
    public void testCrossRoadsNoGroup() throws Exception {
        this.runRoadsTest("zorder/zroads.sld", "z", null, "roads-no-group");
    }

    @Test
    public void testCrossRoadsGrouped() throws Exception {
        this.runRoadsTest("zorder/zroads.sld", "z", "theGroup", "roads-group");
    }

    @Test
    public void testCrossRoadsComplexSort() throws Exception {
        this.runRoadsTest("zorder/zroads.sld", "cat D, name D", "theGroup", "roads-group-complex-sort");
    }

    @Test
    public void testCrossRoadsBuildingsOnZ() throws Exception {
        this.runRoadsBuildingTest("z", "theGroup", "roads-buildings-group-z");
    }

    @Test
    public void testCrossRoadsBuildingsZoomedOut() throws Exception {
        this.bounds.expandBy(10.0, 10.0);
        this.runRoadsBuildingTest("z", "theGroup", "roads-buildings-group-z-zoomedout");
    }

    private void runZSquaresTest(String styleName, String sortBy, String referenceImageName) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        this.forceSortBy(style, sortBy);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zsquares, style));
        this.runImageComparison(referenceImageName, mc);
    }

    private void runRoadsTest(String styleName, String sortBy, String sortByGroup, String referenceImageName) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        this.forceSortBy(style, sortBy);
        this.forceSortByGroup(style, sortByGroup);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zroads, style));
        this.runImageComparison(referenceImageName, mc);
    }

    private void runRoadsBuildingTest(String sortBy, String sortByGroup, String referenceImageName) throws Exception {
        Style roadsStyle = RendererBaseTest.loadStyle(this, "zorder/zroads.sld");
        this.forceSortBy(roadsStyle, sortBy);
        this.forceSortByGroup(roadsStyle, sortByGroup);
        Style buildingsStyle = RendererBaseTest.loadStyle(this, "zorder/zbuildings.sld");
        this.forceSortBy(buildingsStyle, sortBy);
        this.forceSortByGroup(buildingsStyle, sortByGroup);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zroads, roadsStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zbuildings, buildingsStyle));
        this.runImageComparison(referenceImageName, mc);
    }

    private void runImageComparison(String referenceImageName, MapContent mc) throws Exception, IOException {
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                Assert.fail((String)("No rendering errors expected, but got one: " + e.getMessage()));
            }
        });
        BufferedImage image = RendererBaseTest.showRender(referenceImageName, (GTRenderer)renderer, 40000L, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/zorder/" + referenceImageName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)100);
        mc.dispose();
    }

    private void forceSortBy(Style style, String sortBy) {
        if (sortBy != null) {
            for (FeatureTypeStyle fts : style.featureTypeStyles()) {
                fts.getOptions().put("sortBy", sortBy);
            }
        }
    }

    private void forceSortByGroup(Style style, String sortByGroup) {
        if (sortByGroup != null) {
            for (FeatureTypeStyle fts : style.featureTypeStyles()) {
                fts.getOptions().put("sortByGroup", sortByGroup);
            }
        }
    }

    @Test
    public void testInvalidAttribute() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runZRoadsFailureTest("zorder/zpolygon.sld", "not-there", null, new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("not-there"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    @Test
    public void testInvalidSortBySyntax() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runZRoadsFailureTest("zorder/zpolygon.sld", "z upsideDown", null, new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("z upsideDown"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    @Test
    public void testNonComparable() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runZRoadsFailureTest("zorder/zpolygon.sld", "color", null, new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("color"));
                Assert.assertTrue((boolean)e.getMessage().contains("sort"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    @Test
    public void testIncompatibleAttributes() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runRoadsBuildFailureTest("zorder/zpolygon.sld", "z", "cat", "theGroup", new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("z"));
                Assert.assertTrue((boolean)e.getMessage().contains("cat"));
                Assert.assertTrue((boolean)e.getMessage().contains("incompatible"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    @Test
    public void testIncompatibleDirections() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runRoadsBuildFailureTest("zorder/zpolygon.sld", "z A", "z D", "theGroup", new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("order"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    @Test
    public void testDifferentLenghts() throws Exception {
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.runRoadsBuildFailureTest("zorder/zpolygon.sld", "z, cat", "z", "theGroup", new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                failureCount.incrementAndGet();
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                Assert.assertTrue((boolean)e.getMessage().contains("number of attributes"));
            }
        });
        Assert.assertEquals((long)1L, (long)failureCount.get());
    }

    private void runZRoadsFailureTest(String styleName, String sortBy, String sortByGroup, RenderListener listener) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        this.forceSortBy(style, sortBy);
        this.forceSortByGroup(style, sortByGroup);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zroads, style));
        this.runFailureTest(listener, mc);
    }

    private void runFailureTest(RenderListener listener, MapContent mc) throws Exception {
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.addRenderListener(listener);
        RendererBaseTest.showRender("failures", (GTRenderer)renderer, 40000L, this.bounds);
        mc.dispose();
    }

    private void runRoadsBuildFailureTest(String styleName, String sortByRoads, String sortByBuildings, String sortByGroup, RenderListener listener) throws Exception {
        Style roadsStyle = RendererBaseTest.loadStyle(this, "zorder/zroads.sld");
        this.forceSortBy(roadsStyle, sortByRoads);
        this.forceSortByGroup(roadsStyle, sortByGroup);
        Style buildingsStyle = RendererBaseTest.loadStyle(this, "zorder/zbuildings.sld");
        this.forceSortBy(buildingsStyle, sortByBuildings);
        this.forceSortByGroup(buildingsStyle, sortByGroup);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zroads, roadsStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zbuildings, buildingsStyle));
        this.runFailureTest(listener, mc);
    }

    @Test
    public void testZOrderComposite() throws Exception {
        Style roadsStyle = RendererBaseTest.loadStyle(this, "zorder/zroads.sld");
        this.forceSortBy(roadsStyle, "z");
        this.forceSortByGroup(roadsStyle, "theGroup");
        FeatureTypeStyle fts = (FeatureTypeStyle)roadsStyle.featureTypeStyles().get(0);
        fts.getOptions().put("composite-base", "true");
        fts.getOptions().put("composite", "destination-in");
        Style buildingsStyle = RendererBaseTest.loadStyle(this, "zorder/zbuildings.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zbuildings, buildingsStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.zroads, roadsStyle));
        this.runImageComparison("zorder-composite.png", mc);
    }
}

