/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class WrapPointSymbolizerTest {
    private static final long TIME = 4000L;
    SimpleFeatureSource fs;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"bigsquare.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("bigsquare");
    }

    @Test
    public void testWrapPointSymbolizer() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "pointPoly.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 370.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.getViewport().setBounds(bounds);
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        rendererParams.put("continuousMapWrapping", true);
        renderer.setRendererHints(rendererParams);
        renderer.setMapContent(mc);
        BufferedImage image = new BufferedImage(400, 80, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 400, 80);
        renderer.paint(g, new Rectangle(0, 0, 400, 80), bounds);
        mc.dispose();
        RendererBaseTest.showImage("WrapPointSymbolizer", 4000L, image);
        RendererBaseTest.assertPixel(image, 5, 0, Color.BLACK);
        RendererBaseTest.assertPixel(image, 5, 40, Color.RED);
        RendererBaseTest.assertPixel(image, 395, 0, Color.BLACK);
        RendererBaseTest.assertPixel(image, 395, 40, Color.RED);
    }
}

