/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.StyleFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.UomOgcMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnitRescaleTest {
    private StyleFactory sf;
    private FilterFactory ff;

    @Before
    public void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @Test
    public void testUOMEncodingLineSymbolizer() throws Exception {
        LineSymbolizer lineSymbolizer = this.sf.createLineSymbolizer();
        lineSymbolizer.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        lineSymbolizer.setStroke(this.sf.createStroke((Expression)this.ff.literal((Object)"#0000FF"), (Expression)this.ff.literal((Object)"3")));
        Rule rule = this.sf.createRule();
        rule.symbolizers().add(lineSymbolizer);
        Rule[] rules = new Rule[]{rule};
        FeatureTypeStyle featureTypeStyle = this.sf.createFeatureTypeStyle(rules);
        ArrayList<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
        featureTypeStyles.add(featureTypeStyle);
        double dpi90 = 90.7142857142857;
        double widthAtDpi90 = 10714.286;
        Assert.assertEquals((double)widthAtDpi90, (double)this.getStrokeWidth(featureTypeStyles, rules, dpi90), (double)0.1);
        Assert.assertEquals((double)(widthAtDpi90 * 2.0), (double)this.getStrokeWidth(featureTypeStyles, rules, dpi90 * 2.0), (double)0.5);
        Assert.assertEquals((double)(widthAtDpi90 * 3.0), (double)this.getStrokeWidth(featureTypeStyles, rules, dpi90 * 3.0), (double)0.5);
        Assert.assertEquals((double)(widthAtDpi90 * 4.0), (double)this.getStrokeWidth(featureTypeStyles, rules, dpi90 * 4.0), (double)0.5);
        Assert.assertEquals((double)(widthAtDpi90 * 5.0), (double)this.getStrokeWidth(featureTypeStyles, rules, dpi90 * 5.0), (double)0.5);
    }

    private double getStrokeWidth(List<FeatureTypeStyle> featureTypeStyles, Rule[] rules, double dpi) {
        ArrayList<LiteFeatureTypeStyle> lfts = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureTypeStyles) {
            ArrayList<Rule> ruleList = new ArrayList<Rule>(Arrays.asList(rules));
            ArrayList elseRuleList = new ArrayList();
            LiteFeatureTypeStyle s = new LiteFeatureTypeStyle(null, null, ruleList, elseRuleList, fts.getTransformation());
            lfts.add(s);
        }
        HashMap<String, Double> hints = new HashMap<String, Double>();
        hints.put("dpi", dpi);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.scaleDenominator = 1.0;
        renderer.setRendererHints(hints);
        renderer.applyUnitRescale(lfts);
        Iterator iterator = lfts.iterator();
        if (iterator.hasNext()) {
            LiteFeatureTypeStyle s = (LiteFeatureTypeStyle)iterator.next();
            Rule r = s.ruleList[0];
            LineSymbolizer rescaledLineSymbolizer = (LineSymbolizer)r.symbolizers().get(0);
            return (Double)rescaledLineSymbolizer.getStroke().getWidth().evaluate(null, Double.class);
        }
        return -1.0;
    }
}

