/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.google.common.util.concurrent.AtomicDouble;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.easymock.EasyMock;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.Description;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.StyleImpl;
import org.geotools.test.TestData;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class StreamingRendererTest {
    private SimpleFeatureType testLineFeatureType;
    private SimpleFeatureType testPointFeatureType;
    private GeometryFactory gf = new GeometryFactory();
    protected int errors;
    protected int features;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Lines");
        builder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.testLineFeatureType = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.setName("Points");
        builder.add("geom", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.testPointFeatureType = builder.buildFeatureType();
    }

    public SimpleFeatureCollection createLineCollection() throws Exception {
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(this.createLine(-177.0, 0.0, -177.0, 10.0));
        fc.add(this.createLine(-177.0, 0.0, -200.0, 0.0));
        fc.add(this.createLine(-177.0, 0.0, -177.0, 100.0));
        return fc;
    }

    private SimpleFeature createLine(double x1, double y1, double x2, double y2) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString(coords)}, null);
    }

    private SimpleFeature createPoint(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.testPointFeatureType, (Object[])new Object[]{this.gf.createPoint(coord)}, null);
    }

    private Style createLineStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createLineSymbolizer());
    }

    private Style createRasterStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
    }

    private Style createPointStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createPointSymbolizer());
    }

    @Test
    public void testDensification() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{13.0, 10.0, 13.0, 40.0});
        SimpleFeature line = SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString((CoordinateSequence)cs)}, (String)"zz1");
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(line);
        CollectionFeatureSource zzSource = new CollectionFeatureSource((SimpleFeatureCollection)fc);
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)zzSource, sb.createStyle((Symbolizer)sb.createLineSymbolizer())));
        StreamingRenderer sr = new StreamingRenderer();
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("advancedProjectionHandling", true);
        hints.put("advancedProjectionDensificationEnabled", true);
        sr.setRendererHints(hints);
        sr.setMapContent(mc);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        CoordinateReferenceSystem utm32n = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope env = new ReferencedEnvelope(10.0, 20.0, 0.0, 40.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope mapEnv = env.transform(utm32n, true);
        sr.paint(graphics, new Rectangle(0, 0, 100, 100), mapEnv);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertTrue((drawnShape.getGeometry().getCoordinates().length > 2 ? 1 : 0) != 0);
        graphics.dispose();
        hints.put("advancedProjectionDensificationEnabled", false);
        sr.setRendererHints(hints);
        graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        sr.paint(graphics, new Rectangle(0, 0, 100, 100), mapEnv);
        shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        drawnShape = (LiteShape2)shape.getValue();
        Assert.assertEquals((long)2L, (long)drawnShape.getGeometry().getCoordinates().length);
        graphics.dispose();
    }

    @Test
    public void testDensificationWithSmallDomain() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{10.0, 10.0, 10.0, 40.0});
        SimpleFeature line = SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString((CoordinateSequence)cs)}, (String)"zz1");
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(line);
        CollectionFeatureSource zzSource = new CollectionFeatureSource((SimpleFeatureCollection)fc);
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)zzSource, sb.createStyle((Symbolizer)sb.createLineSymbolizer())));
        StreamingRenderer sr = new StreamingRenderer();
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("advancedProjectionHandling", true);
        hints.put("advancedProjectionDensificationEnabled", true);
        sr.setRendererHints(hints);
        sr.setMapContent(mc);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        CoordinateReferenceSystem utm32n = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope env = new ReferencedEnvelope(10.0, 10.5, 39.0, 39.5, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope mapEnv = env.transform(utm32n, true);
        sr.paint(graphics, new Rectangle(0, 0, 100, 100), mapEnv);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertEquals((long)2L, (long)drawnShape.getGeometry().getCoordinates().length);
        graphics.dispose();
    }

    @Test
    public void testDensificationSteps() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 80.0, 0.0, 81.0});
        SimpleFeature line = SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString((CoordinateSequence)cs)}, (String)"line");
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(line);
        CollectionFeatureSource lineSource = new CollectionFeatureSource((SimpleFeatureCollection)fc);
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)lineSource, sb.createStyle((Symbolizer)sb.createLineSymbolizer())));
        final AtomicDouble densification = new AtomicDouble();
        StreamingRenderer sr = new StreamingRenderer(){

            void setupDensificationHints(CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, AffineTransform worldToScreenTransform, Map<String, Object> projectionHints, double tolerance, ReferencedEnvelope sourceEnvelope) throws NoninvertibleTransformException, FactoryException {
                super.setupDensificationHints(mapCRS, featCrs, screenSize, worldToScreenTransform, projectionHints, tolerance, sourceEnvelope);
                Object o = projectionHints.get("advancedProjectionDensify");
                MatcherAssert.assertThat((Object)o, (Matcher)Matchers.instanceOf(Double.class));
                densification.set(((Double)o).doubleValue());
            }
        };
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("advancedProjectionHandling", true);
        hints.put("advancedProjectionDensificationEnabled", true);
        sr.setRendererHints(hints);
        sr.setMapContent(mc);
        CoordinateReferenceSystem webMercator = CRS.decode((String)"EPSG:3857");
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)webMercator);
        double[] point = new double[]{0.0, 80.0};
        mt.transform(point, 0, point, 0, 1);
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope((Rectangle2D)new Rectangle2D.Double(0.0, point[1], 1000.0, point[1] + 1000000.0), webMercator);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        sr.paint(graphics, new Rectangle(0, 0, 1, 1000), referencedEnvelope);
        Assert.assertEquals((double)0.045, (double)densification.get(), (double)0.001);
    }

    @Test
    public void testInterpolationByLayer() throws Exception {
        StreamingRenderer sr = new StreamingRenderer();
        FeatureLayer layer = new FeatureLayer((FeatureCollection)this.createLineCollection(), this.createLineStyle());
        Assert.assertEquals((Object)sr.getRenderingInterpolation((Layer)layer), (Object)Interpolation.getInstance((int)0));
        layer.getUserData().put("byLayerInterpolation", Interpolation.getInstance((int)2));
        Assert.assertEquals((Object)sr.getRenderingInterpolation((Layer)layer), (Object)Interpolation.getInstance((int)2));
        layer.getUserData().put("byLayerInterpolation", Interpolation.getInstance((int)1));
        Assert.assertEquals((Object)sr.getRenderingInterpolation((Layer)layer), (Object)Interpolation.getInstance((int)1));
        layer.getUserData().put("byLayerInterpolation", Interpolation.getInstance((int)0));
        Assert.assertEquals((Object)sr.getRenderingInterpolation((Layer)layer), (Object)Interpolation.getInstance((int)0));
    }

    @Test
    public void testDrawIntepolation() throws Exception {
        MapContent mc = new MapContent();
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BufferedImage testImage = new BufferedImage(200, 200, 6);
        GridCoverage2D testCoverage = new GridCoverageFactory().create((CharSequence)"test", (RenderedImage)testImage, (Bounds)reWgs);
        GridCoverage2D coverage = new GridCoverage2D((CharSequence)"test", testCoverage);
        GridCoverage2DReader gridCoverageReader = (GridCoverage2DReader)Mockito.mock(GridCoverage2DReader.class);
        Mockito.when((Object)gridCoverageReader.getOriginalEnvelope()).thenReturn((Object)new GeneralBounds((Bounds)reWgs));
        Mockito.when((Object)gridCoverageReader.getCoordinateReferenceSystem()).thenReturn((Object)DefaultGeographicCRS.WGS84);
        Mockito.when((Object)gridCoverageReader.read((GeneralParameterValue[])Mockito.any(GeneralParameterValue[].class))).thenReturn((Object)coverage);
        FeatureLayer layer = new FeatureLayer((FeatureCollection)FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)gridCoverageReader, (GeneralParameterValue[])new GeneralParameterValue[0]), this.createRasterStyle());
        layer.getUserData().put("byLayerInterpolation", Interpolation.getInstance((int)3));
        mc.addLayer((Layer)layer);
        BufferedImage image = new BufferedImage(200, 200, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        sr.paint(graphics, new Rectangle(200, 200), reWgs);
        Assert.assertEquals((Object)graphics.getRenderingHint(JAI.KEY_INTERPOLATION), (Object)Interpolation.getInstance((int)3));
        mc.dispose();
    }

    @Test
    public void testEventAfterDrawing() throws Exception {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureCollection)this.createLineCollection(), this.createLineStyle()));
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        ReferencedEnvelope reUtm = reWgs.transform(utm1N, true);
        BufferedImage image = new BufferedImage(200, 200, 6);
        final AtomicInteger commandsCount = new AtomicInteger(0);
        final ArrayBlockingQueue<StreamingRenderer.RenderingRequest> queue = new ArrayBlockingQueue<StreamingRenderer.RenderingRequest>(10){

            @Override
            public void put(StreamingRenderer.RenderingRequest e) throws InterruptedException {
                commandsCount.incrementAndGet();
                super.put(e);
            }
        };
        StreamingRenderer sr = new StreamingRenderer(){

            protected BlockingQueue<StreamingRenderer.RenderingRequest> getRequestsQueue() {
                return queue;
            }
        };
        sr.setMapContent(mc);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                Assert.assertTrue((commandsCount.get() > 0 ? 1 : 0) != 0);
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.errors = 0;
        this.features = 0;
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reUtm);
        mc.dispose();
        Assert.assertTrue((this.errors > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInfiniteLoopAvoidance() throws Exception {
        final RuntimeException sentinel = new RuntimeException("This is the one that should be thrown in hasNext()");
        SimpleFeatureIterator it2 = (SimpleFeatureIterator)EasyMock.createNiceMock(SimpleFeatureIterator.class);
        EasyMock.expect((Object)it2.hasNext()).andThrow((Throwable)sentinel).anyTimes();
        EasyMock.replay((Object[])new Object[]{it2});
        SimpleFeatureCollection fc = (SimpleFeatureCollection)EasyMock.createNiceMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)fc.features()).andReturn((Object)it2);
        EasyMock.expect((Object)fc.size()).andReturn((Object)200);
        EasyMock.expect((Object)((SimpleFeatureType)fc.getSchema())).andReturn((Object)this.testLineFeatureType).anyTimes();
        EasyMock.replay((Object[])new Object[]{fc});
        SimpleFeatureSource fs = (SimpleFeatureSource)EasyMock.createNiceMock(SimpleFeatureSource.class);
        EasyMock.expect((Object)fs.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc);
        EasyMock.expect((Object)((SimpleFeatureType)fs.getSchema())).andReturn((Object)this.testLineFeatureType).anyTimes();
        EasyMock.expect((Object)fs.getSupportedHints()).andReturn(new HashSet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        MapContent mapContext = new MapContent();
        mapContext.addLayer((Layer)new FeatureLayer((FeatureSource)fs, this.createLineStyle()));
        final StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mapContext);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                Throwable t;
                ++StreamingRendererTest.this.errors;
                if (StreamingRendererTest.this.errors > 2) {
                    sr.stopRendering();
                }
                for (t = e; t != sentinel && t.getCause() != null; t = t.getCause()) {
                }
                Assert.assertSame((Object)sentinel, (Object)t);
            }
        });
        this.errors = 0;
        this.features = 0;
        BufferedImage image = new BufferedImage(200, 200, 6);
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reWgs);
        mapContext.dispose();
        Assert.assertEquals((long)0L, (long)this.features);
        Assert.assertEquals((long)1L, (long)this.errors);
    }

    @Test
    public void testDeadlockOnException() throws Exception {
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BufferedImage testImage = new BufferedImage(200, 200, 6);
        GridCoverage2D testCoverage = new GridCoverageFactory().create((CharSequence)"test", (RenderedImage)testImage, (Bounds)reWgs);
        GridCoverage2D oomCoverage = new GridCoverage2D("test", testCoverage){

            public RenderedImage getRenderedImage() {
                throw new OutOfMemoryError("Boom!");
            }
        };
        SimpleFeatureCollection lines = this.createLineCollection();
        Style rasterStyle = this.createRasterStyle();
        Style lineStyle = this.createLineStyle();
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new GridCoverageLayer(oomCoverage, rasterStyle));
        mapContent.addLayer((Layer)new FeatureLayer((FeatureCollection)lines, lineStyle));
        StreamingRenderer sr = new StreamingRenderer(){

            protected StreamingRenderer.RenderingBlockingQueue getRequestsQueue() {
                return new StreamingRenderer.RenderingBlockingQueue((StreamingRenderer)this, 1);
            }
        };
        sr.setMapContent(mapContent);
        final ArrayList exceptions = new ArrayList();
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
                exceptions.add(e);
            }
        });
        this.errors = 0;
        this.features = 0;
        BufferedImage image = new BufferedImage(200, 200, 6);
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reWgs);
        mapContent.dispose();
        Assert.assertTrue((this.features == 4 || this.features == 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.errors);
        Assert.assertTrue((boolean)(((Exception)exceptions.get(0)).getCause() instanceof OutOfMemoryError));
    }

    @Test
    public void testRotatedTransform() throws Exception {
        Rectangle screen = new Rectangle(0, 0, 100, 50);
        Envelope world = new Envelope(0.0, 50.0, 0.0, -100.0);
        AffineTransform worldToScreen = AffineTransform.getRotateInstance(Math.toRadians(90.0), 0.0, 0.0);
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(this.createPoint(0.0, 0.0));
        fc.add(this.createPoint(world.getMaxX(), world.getMinY()));
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)fc, this.createPointStyle()));
        BufferedImage image = new BufferedImage(screen.width, screen.height, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(map);
        sr.paint(image.createGraphics(), screen, map.getMaxBounds(), worldToScreen);
        Assert.assertNotEquals((String)"Pixel should be drawn at 0,0 ", (long)image.getRGB(0, 0), (long)0L);
        Assert.assertEquals((String)"Pixel should not be drawn in image centre ", (long)0L, (long)image.getRGB(screen.width / 2, screen.height / 2));
        Assert.assertNotEquals((String)"Pixel should be drawn at image max corner ", (long)image.getRGB(screen.width - 1, screen.height - 1), (long)0L);
    }

    @Test
    public void testRepeatedEnvelopeExpansion() throws Exception {
        final ArrayList filters = new ArrayList();
        CollectionFeatureSource testSource = new CollectionFeatureSource(this.createLineCollection()){

            public SimpleFeatureCollection getFeatures(Query query) {
                filters.add(query.getFilter());
                return super.getFeatures(query);
            }
        };
        StyleBuilder sb = new StyleBuilder();
        Style style20 = sb.createStyle((Symbolizer)sb.createLineSymbolizer(20.0));
        Style style10 = sb.createStyle((Symbolizer)sb.createLineSymbolizer(10.0));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)testSource, style20));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)testSource, style10));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D graphics = bi.createGraphics();
        sr.paint(graphics, new Rectangle(0, 0, 100, 100), new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        graphics.dispose();
        mc.dispose();
        Assert.assertEquals((long)2L, (long)filters.size());
        Filter f1 = (Filter)filters.get(0);
        Assert.assertTrue((boolean)(f1 instanceof BBOX));
        BoundingBox bbox1 = ((BBOX)f1).getBounds();
        ReferencedEnvelope expected = new ReferencedEnvelope(-11.0, 111.0, -11.0, 111.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((Object)expected, (Object)bbox1);
        Filter f2 = (Filter)filters.get(1);
        Assert.assertTrue((boolean)(f2 instanceof BBOX));
        BoundingBox bbox2 = ((BBOX)f2).getBounds();
        Assert.assertEquals((Object)new ReferencedEnvelope(-6.0, 106.0, -6.0, 106.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Object)bbox2);
    }

    @Test
    public void testScreenMapMemory() {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 0.0, 3.0, 1.0, 4.0, 0.0});
        SimpleFeature zigzag1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString((CoordinateSequence)cs)}, (String)"zz1");
        SimpleFeature zigzag2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.testLineFeatureType, (Object[])new Object[]{this.gf.createLineString((CoordinateSequence)cs)}, (String)"zz2");
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(zigzag1);
        fc.add(zigzag2);
        CollectionFeatureSource zzSource = new CollectionFeatureSource((SimpleFeatureCollection)fc);
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)zzSource, sb.createStyle((Symbolizer)sb.createLineSymbolizer())));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        final ArrayList features = new ArrayList();
        RenderListener renderedFeaturesCollector = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                features.add(feature);
            }

            public void errorOccurred(Exception e) {
            }
        };
        sr.addRenderListener(renderedFeaturesCollector);
        BufferedImage bi = new BufferedImage(1, 1, 5);
        Graphics2D graphics = bi.createGraphics();
        sr.paint(graphics, new Rectangle(0, 0, 1, 1), new ReferencedEnvelope(0.0, 8.0, 0.0, 8.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"zz1", (Object)((SimpleFeature)features.get(0)).getID());
        features.clear();
        sr.paint(graphics, new Rectangle(0, 0, 1, 1), new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        mc.dispose();
        Assert.assertEquals((long)2L, (long)features.size());
        Assert.assertEquals((Object)"zz1", (Object)((SimpleFeature)features.get(0)).getID());
        Assert.assertEquals((Object)"zz2", (Object)((SimpleFeature)features.get(1)).getID());
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindLineStyleAttributeWithAddedFilter() throws Exception {
        final ArrayList filters = new ArrayList();
        CollectionFeatureSource testSource = new CollectionFeatureSource(this.createLineCollection()){

            public SimpleFeatureCollection getFeatures(Query query) {
                filters.add(query.getFilter());
                return super.getFeatures(query);
            }
        };
        Style style = this.createPointStyle();
        MapContent mc = new MapContent();
        FeatureLayer layer = new FeatureLayer((FeatureSource)testSource, style);
        mc.addLayer((Layer)layer);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BBOX bbox = StreamingRenderer.filterFactory.bbox("", 30.0, 60.0, 30.0, 60.0, "EPSG:4326");
        StyleFactoryImpl sf = new StyleFactoryImpl();
        Rule bboxRule = sf.createRule(new Symbolizer[0], (Description)new DescriptionImpl(), null, "bbox", (Filter)bbox, false, 1.0E12, 0.0);
        ((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().add(bboxRule);
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D graphics = bi.createGraphics();
        try {
            sr.paint(graphics, new Rectangle(5, 5, 7, 7), envelope);
        }
        finally {
            graphics.dispose();
            mc.dispose();
        }
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals(FastBBOX.class, ((Filter)filters.get(0)).getClass());
    }

    @Test
    public void testEmptyGeometryRendering() throws Exception {
        MapContent mc = new MapContent();
        File dir = new File(TestData.getResource((Object)this, (String)"empty-geom-rendering.properties").toURI());
        PropertyDataStore dataStore = new PropertyDataStore(dir.getParentFile()){

            protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
                return new PropertyFeatureSource(entry, Query.ALL){

                    protected boolean canFilter(Query query) {
                        return true;
                    }
                };
            }
        };
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        FeatureLayer layer = new FeatureLayer((FeatureSource)dataStore.getFeatureSource("empty-geom-rendering"), style);
        mc.addLayer((Layer)layer);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        BufferedImage img = new BufferedImage(40, 40, 2);
        Graphics2D graphics = img.createGraphics();
        Rectangle paintArea = new Rectangle(40, 40);
        double minx = -8929252.1;
        double maxx = -8708634.6;
        double miny = -491855.7;
        double maxy = -271204.3;
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope((Rectangle2D)new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny), CRS.decode((String)"EPSG:3857"));
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.errors = 0;
        sr.paint(graphics, paintArea, referencedEnvelope);
        mc.dispose();
        Assert.assertEquals((long)0L, (long)this.errors);
    }

    @Test
    public void testStyleThatUsesGeometryDefaultAttribute() throws Exception {
        StyleImpl style = (StyleImpl)RendererBaseTest.loadStyle(this, "genericLines.sld");
        File vectorDataFile = new File(TestData.getResource((Object)this, (String)"genericLines.properties").toURI());
        PropertyDataStore dataStore = new PropertyDataStore(vectorDataFile.getParentFile());
        FeatureLayer layer = new FeatureLayer((FeatureSource)dataStore.getFeatureSource("genericLines"), (Style)style);
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)layer);
        StreamingRenderer gRender = new StreamingRenderer();
        gRender.setMapContent(mapContent);
        gRender.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.features = 0;
        this.errors = 0;
        BufferedImage image = new BufferedImage(40, 40, 2);
        Graphics2D graphics = image.createGraphics();
        Rectangle paintArea = new Rectangle(40, 40);
        double minx = -2.0;
        double maxx = 2.0;
        double miny = -2.0;
        double maxy = 2.0;
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope((Rectangle2D)new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny), CRS.decode((String)"EPSG:4326"));
        gRender.paint(graphics, paintArea, referencedEnvelope);
        mapContent.dispose();
        Assert.assertEquals((long)this.features, (long)4L);
        Assert.assertEquals((long)this.errors, (long)0L);
    }

    @Test
    public void testMergeLayerWithNullImage() {
        BufferedImage finalImage = new BufferedImage(100, 100, 1);
        Graphics2D finalGraphics = (Graphics2D)finalImage.getGraphics();
        finalGraphics.setColor(Color.RED);
        finalGraphics.fillRect(0, 0, 100, 100);
        ArrayList<LiteFeatureTypeStyle> lfts = new ArrayList<LiteFeatureTypeStyle>();
        DirectLayer layer = new DirectLayer(){

            public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
            }

            public ReferencedEnvelope getBounds() {
                return null;
            }
        };
        DelayedBackbufferGraphic graphics = new DelayedBackbufferGraphic(finalGraphics, new Rectangle(100, 100));
        LiteFeatureTypeStyle style1 = new LiteFeatureTypeStyle((Layer)layer, (Graphics2D)graphics, new ArrayList(), new ArrayList(), null);
        style1.composite = AlphaComposite.DstIn;
        lfts.add(style1);
        MergeLayerRequestTester renderer = new MergeLayerRequestTester(finalGraphics, lfts);
        renderer.mergeRequest();
        int color = finalImage.getRGB(0, 0);
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        Assert.assertEquals((long)0L, (long)red);
        Assert.assertEquals((long)0L, (long)green);
        Assert.assertEquals((long)0L, (long)blue);
    }

    @Test
    public void testNPEOnMissingProjectionHandler() throws FactoryException, TransformException {
        StreamingRendererTester tester = new StreamingRendererTester();
        String wkt = "PROJCS[\"World_Eckert_IV\",GEOGCS[\"WGS_1984\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Eckert_IV\"],PARAMETER[\"Central_Meridian\",0.0],UNIT[\"Meter\",1.0]]";
        CoordinateReferenceSystem eckert = CRS.parseWKT((String)wkt);
        ReferencedEnvelope re = new ReferencedEnvelope(-100.0, 100.0, -100.0, 100.0, eckert);
        ReferencedEnvelope reprojected = tester.transformEnvelope(re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertFalse((boolean)reprojected.isNull());
    }

    @Test
    public void testNPEOutsideValidArea() throws Exception {
        String wkt = "PROJCS[\"Homolosine\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563 ] ], PRIMEM[\"Greenwich\",0.0], UNIT[\"degree\",0.01745329251994328 ]],PROJECTION[\"Goode_Homolosine\"],UNIT[\"m\",1.0] ]";
        CoordinateReferenceSystem homolosine = CRS.parseWKT((String)wkt);
        ReferencedEnvelope re = new ReferencedEnvelope(-180.0, -170.0, -90.0, -80.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope cornerHomolosine = re.transform(homolosine, true);
        cornerHomolosine.translate(0.0, -cornerHomolosine.getHeight() * 2.0);
        SimpleFeatureCollection lines = this.createLineCollection();
        Style lineStyle = this.createLineStyle();
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new FeatureLayer((FeatureCollection)lines, lineStyle));
        StreamingRenderer sr = new StreamingRenderer();
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("advancedProjectionHandling", true);
        hints.put("advancedProjectionDensificationEnabled", true);
        sr.setRendererHints(hints);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.errors = 0;
        sr.setMapContent(mapContent);
        BufferedImage image = new BufferedImage(200, 200, 6);
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), cornerHomolosine);
        mapContent.dispose();
        Assert.assertEquals((long)0L, (long)this.errors);
    }

    @Test
    public void testGEOT6995() throws IOException, FactoryException {
        URL url = TestData.url(StreamingRenderer.class, (String)"mzdata/170715_1_TrjLines.shp");
        ShapefileDataStore store = new ShapefileDataStore(url);
        ContentFeatureCollection inFeatures = store.getFeatureSource().getFeatures();
        FeatureLayer fred = new FeatureLayer((FeatureCollection)inFeatures, this.createPointStyle());
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)fred);
        StreamingRenderer gRender = new StreamingRenderer();
        gRender.setMapContent(mapContent);
        gRender.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++StreamingRendererTest.this.features;
            }

            public void errorOccurred(Exception e) {
                ++StreamingRendererTest.this.errors;
            }
        });
        this.features = 0;
        this.errors = 0;
        BufferedImage image = new BufferedImage(40, 40, 2);
        Graphics2D graphics = image.createGraphics();
        Rectangle paintArea = new Rectangle(40, 40);
        gRender.paint(graphics, paintArea, fred.getBounds());
        mapContent.dispose();
        Assert.assertEquals((long)0L, (long)this.errors);
        Assert.assertEquals((long)inFeatures.size(), (long)this.features);
    }

    @Test
    public void testInvalidSimplificationDistance() throws Exception {
        Style lineStyle = this.createLineStyle();
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_DISTANCE, lineStyle);
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, lineStyle);
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_GENERALIZATION, lineStyle);
        Style rtStyle = RendererBaseTest.loadStyle(this, "attributeRename.sld");
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_DISTANCE, rtStyle);
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, rtStyle);
        this.testInvalidSimplificationDistance2((RenderingHints.Key)Hints.GEOMETRY_GENERALIZATION, rtStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testInvalidSimplificationDistance2(final RenderingHints.Key hint, Style style) throws Exception {
        final AtomicReference reference = new AtomicReference();
        CollectionFeatureSource testSource = new CollectionFeatureSource(this.createLineCollection()){

            public SimpleFeatureCollection getFeatures(Query query) {
                reference.set(query.getHints().get((Object)hint));
                return super.getFeatures(query);
            }

            public synchronized Set<RenderingHints.Key> getSupportedHints() {
                return Set.of(hint);
            }
        };
        MapContent mc = new MapContent();
        FeatureLayer layer = new FeatureLayer((FeatureSource)testSource, style);
        mc.addLayer((Layer)layer);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        ReferencedEnvelope envelope = new ReferencedEnvelope(-1.0E7, 1.0E7, -1.0E7, 1.0E7, CRS.decode((String)"AUTO:42003,9001,45,0"));
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D graphics = bi.createGraphics();
        try {
            sr.paint(graphics, new Rectangle(5, 5, 7, 7), envelope);
        }
        finally {
            graphics.dispose();
            mc.dispose();
        }
        Assert.assertNull((String)"Got a distance simplification reference, unexpected", reference.get());
    }

    private class StreamingRendererTester
    extends StreamingRenderer {
        private StreamingRendererTester() {
        }

        public ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
            return super.transformEnvelope(envelope, crs);
        }
    }

    private static final class MergeLayerRequestTester
    extends StreamingRenderer {
        Graphics2D graphics;
        List<LiteFeatureTypeStyle> styles;

        public MergeLayerRequestTester(Graphics2D graphics, List<LiteFeatureTypeStyle> styles) {
            this.graphics = graphics;
            this.styles = styles;
            this.styles = styles;
        }

        public void mergeRequest() {
            StreamingRenderer.MergeLayersRequest request = new StreamingRenderer.MergeLayersRequest((StreamingRenderer)this, this.graphics, this.styles);
            request.execute();
        }
    }
}

