/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.jaitools.swing.ImageFrame;
import org.junit.Assert;
import org.junit.Test;

public class StreamingRendererDirectLayerTest {
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final Rectangle SCREEN = new Rectangle(200, 200);

    @Test
    public void rendererRecognizesDirectLayer() {
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new MockLayer());
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mapContent);
        BufferedImage image = new BufferedImage(StreamingRendererDirectLayerTest.SCREEN.width, StreamingRendererDirectLayerTest.SCREEN.height, 2);
        mapContent.getViewport().setScreenArea(SCREEN);
        Graphics2D destGraphics = image.createGraphics();
        renderer.paint(destGraphics, SCREEN, WORLD);
        mapContent.dispose();
        Map<Integer, Integer> colorFreq = this.getColorFreq(image);
        Assert.assertEquals((long)2L, (long)colorFreq.size());
        Assert.assertTrue((boolean)colorFreq.containsKey(Color.BLACK.getRGB()));
        Assert.assertTrue((boolean)colorFreq.containsKey(Color.WHITE.getRGB()));
        double ratio = (double)colorFreq.get(Color.BLACK.getRGB()).intValue() / (double)colorFreq.get(Color.WHITE.getRGB()).intValue();
        Assert.assertTrue((ratio > 0.95 && ratio < 1.05 ? 1 : 0) != 0);
        if (TestData.isInteractiveTest()) {
            CountDownLatch latch = new CountDownLatch(1);
            this.displayImage(image, latch);
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Map<Integer, Integer> getColorFreq(BufferedImage image) {
        HashMap<Integer, Integer> colorFreq = new HashMap<Integer, Integer>();
        int y = image.getMinY();
        for (int ny = 0; ny < image.getHeight(); ++ny) {
            int x = image.getMinX();
            for (int nx = 0; nx < image.getWidth(); ++nx) {
                int rgb = image.getRGB(x, y);
                Integer freq = (Integer)colorFreq.get(rgb);
                if (freq == null) {
                    colorFreq.put(rgb, 1);
                } else {
                    Integer n = freq;
                    Integer n2 = freq = Integer.valueOf(freq + 1);
                }
                ++x;
            }
            ++y;
        }
        return colorFreq;
    }

    private void displayImage(BufferedImage image, CountDownLatch latch) {
        SwingUtilities.invokeLater(() -> {
            TestImageFrame frame = new TestImageFrame(image, latch);
            frame.setVisible(true);
        });
    }

    private static class TestImageFrame
    extends ImageFrame {
        BufferedImage image;

        public TestImageFrame(BufferedImage image, final CountDownLatch latch) {
            super((RenderedImage)image, "Rendered image");
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    latch.countDown();
                }
            });
            this.setSize(image.getWidth(), image.getHeight() + 21);
        }
    }

    private class MockLayer
    extends DirectLayer {
        private MockLayer() {
        }

        public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
            Graphics2D localGraphics = (Graphics2D)graphics.create();
            localGraphics.setPaint(Color.WHITE);
            localGraphics.fill(SCREEN);
            Rectangle inner = new Rectangle(StreamingRendererDirectLayerTest.SCREEN.x + StreamingRendererDirectLayerTest.SCREEN.width / 4, StreamingRendererDirectLayerTest.SCREEN.y + StreamingRendererDirectLayerTest.SCREEN.height / 4, StreamingRendererDirectLayerTest.SCREEN.width / 2, StreamingRendererDirectLayerTest.SCREEN.height / 2);
            localGraphics.setPaint(Color.BLACK);
            localGraphics.fill(inner);
        }

        public ReferencedEnvelope getBounds() {
            return WORLD;
        }
    }
}

