/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class RenderingSelectionTest {
    SimpleFeatureSource pointFS;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"pointRotation.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.pointFS = ds.getFeatureSource("pointRotation");
    }

    @Test
    public void testRuleSelection() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "pointRenderingSelectionRule.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("Rule rendering selection", (GTRenderer)renderer, 3000L, new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326")));
        ImageAssert.assertEquals((File)this.file("mapRenderingSelectionRule"), (RenderedImage)image, (int)150);
    }

    @Test
    public void testFeatureTypeStyleSelection() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "pointRenderingSelectionFTS.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("FTS rendering selection", (GTRenderer)renderer, 3000L, new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326")));
        ImageAssert.assertEquals((File)this.file("mapRenderingSelectionFTS"), (RenderedImage)image, (int)150);
    }

    @Test
    public void testSymbolizerStyleSelection() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "pointRenderingSelectionSymbolizer.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("FTS rendering selection", (GTRenderer)renderer, 3000L, new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326")));
        ImageAssert.assertEquals((File)this.file("mapRenderingSelectionSymbolizer"), (RenderedImage)image, (int)150);
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/renderingSelection/" + name + ".png");
    }
}

