/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.styling.StyleBuilder;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;

public class RenderingBufferExtractorTest {
    StyleBuilder sb = new StyleBuilder();
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testTextNoStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createTextSymbolizer());
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        Assert.assertEquals((long)0L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
        rbe.visit(style);
        Assert.assertEquals((long)15L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testTextDisplaced() {
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.setFont(this.sb.createFont("Arial", 20.0));
        PointPlacement pp = this.sb.createPointPlacement(1.0, 1.0, 10.0, 10.0, 0.0);
        ts.setLabelPlacement((LabelPlacement)pp);
        Style style = this.sb.createStyle((Symbolizer)ts);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)40L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testSimpleStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(10.0)));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testSimpleGraphic() {
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, this.sb.createMark("circle"), null));
        ps.getGraphic().setSize(this.sb.literalExpression(15));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)16L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testReachableExternalGraphic() {
        URL resource = TestData.getResource((Object)this, (String)"draw.png");
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, null, (Symbol)this.sb.createExternalGraphic(resource, "image/png")));
        ps.getGraphic().setSize(this.sb.literalExpression(null));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)24L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testUnreachableExternalGraphic() throws Exception {
        File file = new File(TestData.getResource((Object)this, (String)"draw.png").toURI());
        URL resource = new File(file.getParent(), "draw-not-there.png").toURI().toURL();
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, null, (Symbol)this.sb.createExternalGraphic(resource, "image/png")));
        ps.getGraphic().setSize(this.sb.literalExpression(null));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)0L, (long)rbe.getBuffer());
        Assert.assertFalse((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testNonIntegerStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(10.8)));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)11L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testMultiSymbolizers() {
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(10.8));
        PolygonSymbolizer ps = this.sb.createPolygonSymbolizer(this.sb.createStroke(12.0), this.sb.createFill());
        Rule r = this.sb.createRule(new Symbolizer[]{ls, ps});
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)12L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testPropertyWidth() {
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.attributeExpression("gimbo")));
        PolygonSymbolizer ps = this.sb.createPolygonSymbolizer(this.sb.createStroke(12.0), this.sb.createFill());
        Rule r = this.sb.createRule(new Symbolizer[]{ls, ps});
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)12L, (long)rbe.getBuffer());
        Assert.assertFalse((boolean)rbe.isEstimateAccurate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnvironmentWidth() {
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), (Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"thickness"), this.ff.literal(10)})));
        Rule r = this.sb.createRule((Symbolizer)ls);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
        EnvFunction.setLocalValue((String)"thickness", (Object)15);
        try {
            rbe.visit(r);
            Assert.assertEquals((long)15L, (long)rbe.getBuffer());
            Assert.assertTrue((boolean)rbe.isEstimateAccurate());
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testConstantFunction() {
        Function cos = this.ff.function("cos", new Expression[]{this.ff.literal(Math.toRadians(Math.PI))});
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), (Expression)cos));
        Rule r = this.sb.createRule((Symbolizer)ls);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)1L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testMath() {
        Add add = this.ff.add((Expression)this.ff.literal((Object)"5"), (Expression)this.ff.literal((Object)"-2"));
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), (Expression)add));
        Rule r = this.sb.createRule((Symbolizer)ls);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)3L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testLiteralParseStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.literalExpression("10.0"))));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testNpePreventionStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.literalExpression(null))));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)1L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testLiteralParseGraphics() {
        Graphic g = this.sb.createGraphic();
        g.setSize(this.sb.literalExpression("10.0"));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(g);
        Assert.assertEquals((long)11L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }
}

