/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MultiScriptTest {
    private static final long TIME = 10000L;
    static final int TOLERANCE = 3000;
    GeometryFactory gf = new GeometryFactory();
    SimpleFeatureSource points;
    SimpleFeatureSource lines;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource((Object)this, (String)"DroidSansArmenian.ttf").openStream()));
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource((Object)this, (String)"DroidSansArmenian.ttf").openStream()));
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource((Object)this, (String)"DroidNaskh-Regular.ttf").openStream()));
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null);
        this.buildPointFeatures();
        this.buildLineFeatures();
    }

    private void buildPointFeatures() throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.setName("multiScript");
        SimpleFeatureType type = builder.buildFeatureType();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.gf.createPoint(new Coordinate(5.0, 9.0)), "Some latin and some armenian\n\u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.gf.createPoint(new Coordinate(5.0, 6.0)), "Latin, arab, armenian\n\u0627\u062e\u062a\u0628\u0627\u0631\n\u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566"}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.gf.createPoint(new Coordinate(7.5, 3.0)), "armenian \u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566"}, null);
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.gf.createPoint(new Coordinate(2.5, 3.0)), "\u0627\u062e\u062a\u0628\u0627\u0631"}, null);
        SimpleFeature f5 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.gf.createPoint(new Coordinate(5.0, 1.0)), "\u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566  abc  \u0627\u062e\u062a\u0628\u0627\u0631"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        data.addFeature(f3);
        data.addFeature(f4);
        data.addFeature(f5);
        this.points = data.getFeatureSource("multiScript");
    }

    private void buildLineFeatures() throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", LineString.class);
        builder.add("label", String.class);
        builder.setName("multiScript");
        SimpleFeatureType type = builder.buildFeatureType();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.circleArcInBounds(5.0, 0.0, 8.0, this.bounds), "armenian    \u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.circleArcInBounds(5.0, -3.0, 8.0, this.bounds), "\u0562\u0561\u0580\u0565\u0582 \u0541\u0565\u0566 abc \u0627\u062e\u062a\u0628\u0627\u0631"}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.circleArcInBounds(5.0, -6.0, 8.0, this.bounds), "\u062a\u0635\u0628\u062d/ \u062a\u0635\u0628\u062d\u064a\u0646 \u0639\u0644\u0649 \u062e\u064a\u0631"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        data.addFeature(f3);
        this.lines = data.getFeatureSource("multiScript");
    }

    private LineString circleArcInBounds(double x, double y, double radius, ReferencedEnvelope bounds) {
        Point center = this.gf.createPoint(new Coordinate(x, y));
        Polygon buffered = (Polygon)center.buffer(radius, 64);
        Polygon mask = JTS.toGeometry((ReferencedEnvelope)bounds);
        Geometry intersection = buffered.getExteriorRing().intersection((Geometry)mask);
        return (LineString)intersection;
    }

    @Test
    public void testMultiScriptPoint() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "multiscript/textMultiScript.sld");
        BufferedImage image = this.renderLabels(this.points, style, "Multi script");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/multiscript/textMultiScript.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    @Test
    public void testMultiScriptPointWrap() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "multiscript/textMultiScriptWrap.sld");
        BufferedImage image = this.renderLabels(this.points, style, "Multi script wrap");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/multiscript/textMultiScriptWrap.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    @Test
    public void testMultiScriptLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "multiscript/textMultiScriptLine.sld");
        BufferedImage image = this.renderLabels(this.lines, style, "Multi script lines");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/multiscript/textMultiScriptLine.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    private BufferedImage renderLabels(SimpleFeatureSource fs, Style style, String title) throws Exception {
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        return RendererBaseTest.showRender(title, (GTRenderer)renderer, 10000L, this.bounds);
    }

    @Test
    public void testFollowLineWithLocalTransform() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "multiscript/textMultiScriptLine.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lines, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        int SIZE = 300;
        BufferedImage image = new BufferedImage(SIZE, SIZE, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, SIZE, SIZE);
        g.setTransform(new AffineTransform(1.1, Math.sin(Math.toRadians(15.0)), -Math.sin(Math.toRadians(15.0)), 1.1, 15.0, 20.0));
        renderer.paint(g, new Rectangle(SIZE, SIZE), this.bounds);
        mc.dispose();
        renderer.getMapContent().dispose();
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/multiscript/textMultiScriptTransformedLine.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }
}

