/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataTestCase;
import org.geotools.filter.function.EnvFunction;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MetaBufferEstimatorTest
extends DataTestCase {
    @Test
    public void testExternalGraphic() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphic.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)48L, (long)estimator.getBuffer());
    }

    @Test
    public void testExternalGraphicRectangleResized() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicRectImage.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)32L, (long)estimator.getBuffer());
    }

    @Test
    public void testExternalGraphicNoSize() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicNoSize.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)64L, (long)estimator.getBuffer());
    }

    @Test
    public void testMark() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "markCircle.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)32L, (long)estimator.getBuffer());
    }

    @Test
    public void testThinLine() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineGray.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)1L, (long)estimator.getBuffer());
    }

    @Test
    public void testThickLine() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineThick.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)4L, (long)estimator.getBuffer());
    }

    @Test
    public void testGraphicStroke() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineRailway.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)10L, (long)estimator.getBuffer());
    }

    @Test
    public void testPolygon() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "polygon.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)1L, (long)estimator.getBuffer());
    }

    @Test
    public void testLabelShields() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textLabelShield.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)32L, (long)estimator.getBuffer());
    }

    @Test
    public void testDynamicSize() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicDynamicSize.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertFalse((boolean)estimator.isEstimateAccurate());
    }

    @Test
    public void testInlineContent() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "base64.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)16L, (long)estimator.getBuffer());
    }

    @Test
    public void testMarkNoSizeNoStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.setStroke(null);
        Graphic graphic = sb.createGraphic(null, mark, null);
        graphic.setSize(NilExpression.NIL);
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)16L, (long)estimator.getBuffer());
    }

    @Test
    public void testMarkStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.getStroke().setWidth((Expression)sb.getFilterFactory().literal(10));
        Graphic graphic = sb.createGraphic(null, mark, null);
        graphic.setSize(NilExpression.NIL);
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)26L, (long)estimator.getBuffer());
    }

    @Test
    public void testNullStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        LineSymbolizer ls = sb.createLineSymbolizer(StrokeImpl.NULL);
        Style style = sb.createStyle((Symbolizer)ls);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)0L, (long)estimator.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGraphicSizeFunction() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.setStroke(null);
        Graphic graphic = sb.createGraphic(null, mark, null);
        FilterFactory ff = sb.getFilterFactory();
        graphic.setSize((Expression)ff.function("env", new Expression[]{ff.literal((Object)"test")}));
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        try {
            EnvFunction.setGlobalValue((String)"test", (Object)10);
            MetaBufferEstimator estimator = new MetaBufferEstimator();
            style.accept((StyleVisitor)estimator);
            Assert.assertTrue((boolean)estimator.isEstimateAccurate());
            Assert.assertEquals((long)10L, (long)estimator.getBuffer());
        }
        finally {
            EnvFunction.clearGlobalValues();
        }
    }

    @Test
    public void testMultiScript() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "multiscript/textMultiScriptLine.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)16L, (long)estimator.getBuffer());
    }

    @Test
    public void testFeatureBound() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        LineSymbolizer ls = sb.createLineSymbolizer(Color.BLUE);
        ls.getStroke().setWidth((Expression)this.ff.multiply((Expression)this.ff.literal(2), (Expression)this.ff.property("flow")));
        Style style = sb.createStyle((Symbolizer)ls);
        MetaBufferEstimator estimator = new MetaBufferEstimator((Feature)this.riverFeatures[0]);
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)9L, (long)estimator.getBuffer());
    }
}

