/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MarkAlongLineTest {
    private static final long TIME = 5000L;
    SimpleFeatureSource lineFS;
    SimpleFeatureSource polygonFS;
    Style squareWaveMarkerStyle;
    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        File property = new File(TestData.getResource((Object)this, (String)"markAlongLine.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.lineFS = ds.getFeatureSource("markAlongLine");
        Assert.assertNotNull((Object)this.lineFS);
        this.polygonFS = ds.getFeatureSource("markAlongLinePolygon");
        Assert.assertNotNull((Object)this.polygonFS);
        this.squareWaveMarkerStyle = RendererBaseTest.loadStyle(this, "markAlongLine_sqaure_wave.sld");
        Assert.assertNotNull((Object)this.squareWaveMarkerStyle);
    }

    @Test
    public void testAllSquareWaveAngles() throws Exception {
        FeatureLayer lineLayer = new FeatureLayer((FeatureSource)this.lineFS, this.squareWaveMarkerStyle);
        SimpleFeatureCollection fc = lineLayer.getSimpleFeatureSource().getFeatures((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"all_turns"), true));
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope env = fc.getBounds();
        env.expandBy(0.05);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)lineLayer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("WKT drapped along line", (GTRenderer)renderer, 5000L, env);
        File squareLineAllAngles = new File(TestData.getResource((Object)this, (String)"markAlongLine_sqaure_all_angles.png").toURI());
        ImageAssert.assertEquals((File)squareLineAllAngles, (RenderedImage)image, (int)200);
    }

    @Test
    public void testCurvedSquareWaves() throws Exception {
        FeatureLayer lineLayer = new FeatureLayer((FeatureSource)this.lineFS, this.squareWaveMarkerStyle);
        SimpleFeatureCollection fc = lineLayer.getSimpleFeatureSource().getFeatures((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"curve"), true));
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope env = fc.getBounds();
        env.expandBy(0.05);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)lineLayer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("WKT drapped along line", (GTRenderer)renderer, 5000L, env);
        File squareLineAllAngles = new File(TestData.getResource((Object)this, (String)"markAlongLine_sqaure_curve.png").toURI());
        ImageAssert.assertEquals((File)squareLineAllAngles, (RenderedImage)image, (int)200);
    }

    @Test
    public void testRightAngledSquareWaves() throws Exception {
        FeatureLayer lineLayer = new FeatureLayer((FeatureSource)this.lineFS, this.squareWaveMarkerStyle);
        SimpleFeatureCollection fc = lineLayer.getSimpleFeatureSource().getFeatures((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"right_angle"), true));
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope env = fc.getBounds();
        env.expandBy(0.025);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)lineLayer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("WKT drapped along line", (GTRenderer)renderer, 5000L, env);
        File squareLineAllAngles = new File(TestData.getResource((Object)this, (String)"markAlongLine_sqaure_right_angle.png").toURI());
        ImageAssert.assertEquals((File)squareLineAllAngles, (RenderedImage)image, (int)200);
    }

    @Test
    public void testTurnBackAngledSquareWaves() throws Exception {
        FeatureLayer lineLayer = new FeatureLayer((FeatureSource)this.lineFS, this.squareWaveMarkerStyle);
        SimpleFeatureCollection fc = lineLayer.getSimpleFeatureSource().getFeatures((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"turn_back"), true));
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope env = fc.getBounds();
        env.expandBy(0.01);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)lineLayer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("WKT drapped along line", (GTRenderer)renderer, 5000L, env);
        File squareLineAllAngles = new File(TestData.getResource((Object)this, (String)"markAlongLine_sqaure_turn_back.png").toURI());
        ImageAssert.assertEquals((File)squareLineAllAngles, (RenderedImage)image, (int)200);
    }

    @Test
    public void testPolygon() throws Exception {
        FeatureLayer polygonLayer = new FeatureLayer((FeatureSource)this.polygonFS, this.squareWaveMarkerStyle);
        SimpleFeatureCollection fc = polygonLayer.getSimpleFeatureSource().getFeatures((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)"all_turns"), true));
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        ReferencedEnvelope env = fc.getBounds();
        env.expandBy(1.1);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)polygonLayer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("WKT drapped along polygon boundary", (GTRenderer)renderer, 5000L, env);
        File squareLineAllAngles = new File(TestData.getResource((Object)this, (String)"markAlongLine_polygon.png").toURI());
        ImageAssert.assertEquals((File)squareLineAllAngles, (RenderedImage)image, (int)200);
    }
}

