/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LetterConflictTest {
    static final Logger LOGGER = Logging.getLogger(LetterConflictTest.class);
    static final boolean IMAGE_INTERACTIVE = Boolean.getBoolean("org.geotools.image.test.interactive");
    private static boolean IMAGE_SKIP = Boolean.getBoolean("org.geotools.image.test.skip");
    private static boolean OUTPUT_IMAGE = Boolean.getBoolean("org.geotools.image.test.output");
    private static final long TIME = 5000L;
    SimpleFeatureSource fs_line1;
    SimpleFeatureSource fs_line2;
    SimpleFeatureSource fs_line3;
    SimpleFeatureSource fs_line4;
    ReferencedEnvelope bounds1;
    ReferencedEnvelope bounds2;

    @Before
    public void setUp() throws Exception {
        File property_line = new File(TestData.getResource((Object)this, (String)"letterConflict1.properties").toURI());
        PropertyDataStore ds_line = new PropertyDataStore(property_line.getParentFile());
        this.fs_line1 = ds_line.getFeatureSource("letterConflict1");
        this.fs_line2 = ds_line.getFeatureSource("letterConflict2");
        this.fs_line3 = ds_line.getFeatureSource("letterConflict3");
        this.bounds1 = new ReferencedEnvelope(-10.0, 10.0, -10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.fs_line4 = ds_line.getFeatureSource("letterConflict4");
        this.bounds2 = new ReferencedEnvelope(20.0, 80.0, 23.0, 86.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        RendererBaseTest.setupVeraFonts();
    }

    private StreamingRenderer getNewRenderer(MapContent context) {
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        renderer.setRendererHints(rendererParams);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(context);
        return renderer;
    }

    @Test
    public void testLetterConflictEnabled() throws Exception {
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = true;
        Style style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line1, style));
        StreamingRenderer renderer = this.getNewRenderer(mc);
        BufferedImage image1 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        mc.dispose();
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = false;
        style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line1, style));
        renderer = this.getNewRenderer(mc);
        BufferedImage image2 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        mc.dispose();
        Assert.assertTrue((String)"More labels in image2 than image1", (this.countPixels(image2, Color.BLACK) >= this.countPixels(image1, Color.BLACK) ? 1 : 0) != 0);
        LetterConflictTest.writeImage("letterConflictEnabledFalse", image1);
        LetterConflictTest.writeImage("letterConflictEnabledTrue", image2);
        LetterConflictTest.showImage("letterConflictEnabled false", 5000L, image1);
        LetterConflictTest.showImage("letterConflictEnabled true", 5000L, image2);
    }

    @Test
    public void testLetterConflictEnabled2Lines() throws Exception {
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = true;
        Style style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line2, style));
        StreamingRenderer renderer = this.getNewRenderer(mc);
        BufferedImage image1 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        mc.dispose();
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = false;
        style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line2, style));
        renderer = this.getNewRenderer(mc);
        BufferedImage image2 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        Assert.assertTrue((String)"More labels in image2 than image1", (this.countPixels(image2, Color.BLACK) > this.countPixels(image1, Color.BLACK) ? 1 : 0) != 0);
        LetterConflictTest.writeImage("letterConflictEnabled2False", image1);
        LetterConflictTest.writeImage("letterConflictEnabled2True", image2);
        LetterConflictTest.showImage("letterConflictEnabled2 false", 5000L, image1);
        LetterConflictTest.showImage("letterConflictEnabled2 true", 5000L, image2);
        mc.dispose();
    }

    @Test
    public void testLetterConflictEnabledCurvedLine() throws Exception {
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = true;
        Style style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line3, style));
        StreamingRenderer renderer = this.getNewRenderer(mc);
        BufferedImage image1 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        mc.dispose();
        LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = false;
        style = RendererBaseTest.loadStyle(this, "letterConflict20.sld");
        mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line3, style));
        renderer = this.getNewRenderer(mc);
        BufferedImage image2 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds1, null);
        mc.dispose();
        Assert.assertTrue((String)"More labels in image2 than image1", (this.countPixels(image2, Color.BLACK) > this.countPixels(image1, Color.BLACK) ? 1 : 0) != 0);
        LetterConflictTest.writeImage("letterConflictEnabledCurvedLineFalse", image1);
        LetterConflictTest.writeImage("letterConflictEnabledCurvedLineTrue", image2);
        LetterConflictTest.showImage("letterConflictEnabledCurvedLine false", 5000L, image1);
        LetterConflictTest.showImage("letterConflictEnabledCurvedLine true", 5000L, image2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLetterConflictEnabledPerf() throws Exception {
        Class<LabelCacheImpl> clazz = LabelCacheImpl.class;
        synchronized (LabelCacheImpl.class) {
            LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = true;
            Style style = RendererBaseTest.loadStyle(this, "letterConflict6.sld");
            MapContent mc = new MapContent();
            mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line4, style));
            StreamingRenderer renderer = this.getNewRenderer(mc);
            BufferedImage image1 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds2, null);
            long ta = 0L;
            for (int i = 0; i < 10; ++i) {
                renderer = this.getNewRenderer(mc);
                long t0 = System.nanoTime();
                image1 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds2, null);
                long t1 = System.nanoTime();
                ta += t1 - t0;
            }
            LOGGER.fine("time false " + ta / 10000000L);
            mc.dispose();
            LabelCacheImpl.DISABLE_LETTER_LEVEL_CONFLICT = false;
            mc = new MapContent();
            mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line4, style));
            renderer = this.getNewRenderer(mc);
            BufferedImage image2 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds2, null);
            ta = 0L;
            for (int i = 0; i < 10; ++i) {
                renderer = this.getNewRenderer(mc);
                long t2 = System.nanoTime();
                image2 = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds2, null);
                long t3 = System.nanoTime();
                ta += t3 - t2;
            }
            LOGGER.fine("time true " + ta / 10000000L);
            mc.dispose();
            Assert.assertTrue((String)"More labels in image2 than image1", (this.countDarkPixels(image2) >= this.countDarkPixels(image1) ? 1 : 0) != 0);
            LetterConflictTest.writeImage("letterConflictEnabledPerfFalse", image1);
            LetterConflictTest.writeImage("letterConflictEnabledPerfTrue", image2);
            LetterConflictTest.showImage("letterConflictEnabledPref false", 5000L, image1);
            LetterConflictTest.showImage("letterConflictEnabledPerf true", 5000L, image2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int countPixels(BufferedImage bi, Color color) {
        int count = 0;
        for (int i = 0; i < bi.getWidth(); ++i) {
            for (int j = 0; j < bi.getHeight(); ++j) {
                if (bi.getRGB(i, j) != color.getRGB()) continue;
                ++count;
            }
        }
        return count;
    }

    public int countDarkPixels(BufferedImage bi) {
        int count = 0;
        for (int i = 0; i < bi.getWidth(); ++i) {
            for (int j = 0; j < bi.getHeight(); ++j) {
                Color col = new Color(bi.getRGB(i, j));
                if (col.getBlue() >= 127 || col.getGreen() >= 127 || col.getRed() >= 127) continue;
                ++count;
            }
        }
        return count;
    }

    static void writeImage(String testName, BufferedImage image) throws IOException {
        if (IMAGE_SKIP) {
            return;
        }
        if (OUTPUT_IMAGE) {
            File tmpFile = File.createTempFile("geotools-" + testName, ".png");
            ImageIO.write((RenderedImage)image, "png", tmpFile);
        }
    }

    static void showImage(String testName, long timeOut, final BufferedImage image) throws InterruptedException {
        boolean HEADLESS = Boolean.getBoolean("java.awt.headless");
        if (HEADLESS || IMAGE_SKIP) {
            return;
        }
        if (IMAGE_INTERACTIVE && TestData.isInteractiveTest()) {
            try {
                Frame frame = new Frame(testName);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
                Panel p = new Panel(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.drawImage(image, 0, 0, this);
                    }
                };
                frame.add(p);
                frame.pack();
                frame.setVisible(true);
                Thread.sleep(timeOut);
                frame.dispose();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

