/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.geotools.xml.styling.SLDParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class LabelingTest {
    private long timout = 3000L;
    private static final int CENTERX = 130;
    private static final int CENTERY = 40;

    @Before
    public void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPointLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createPointFeatureCollection();
        Style style = this.loadStyle("PointStyle.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testPointLabeling", (GTRenderer)renderer, this.timout, env);
    }

    private Style loadStyle(String sldFilename) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        URL surl = TestData.getResource((Object)this, (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }

    private SimpleFeatureCollection createPointFeatureCollection() throws Exception {
        AttributeDescriptor[] types = new AttributeDescriptor[2];
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createPointFeature(2, 2, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(4, 4, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(0, 4, "LongLabel3", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(2, 6, "LongLabel6", (CoordinateReferenceSystem)crs, geomFac, types));
        return data.getFeatureSource("pointfeature").getFeatures();
    }

    private SimpleFeature createPointFeature(int x, int y, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac, AttributeDescriptor[] types) throws Exception {
        Coordinate c = new Coordinate((double)x, (double)y);
        Point point = geomFac.createPoint(c);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("point", point.getClass(), crs);
        } else {
            builder.add("centre", point.getClass());
        }
        builder.add("name", String.class);
        builder.setName("pointfeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point, name}, null);
    }

    @Test
    public void testLineLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createLineFeatureCollection();
        Style style = this.loadStyle("LineStyle.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testLineLabeling", (GTRenderer)renderer, this.timout, env);
    }

    @Test
    public void testLineLabelingUom() throws Exception {
        SimpleFeatureCollection collection = this.createLineFeatureCollection();
        Style style = this.loadStyle("LineStyleUom.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        int boundary = 10000;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testLineLabeling", (GTRenderer)renderer, this.timout, env);
    }

    @Test
    public void testLineLabelingSharpTurn() throws Exception {
        SimpleFeatureCollection collection = this.createTightUTurnLineCollection();
        Style style = this.loadStyle("LineStyleLarge.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(map);
        int boundary = 2;
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        BufferedImage image = RendererBaseTest.showRender("U turn label", (GTRenderer)renderer, 1000L, env);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelSharpTurn.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)100);
    }

    @Test
    public void testLineLabelingSharpTurn2() throws Exception {
        SimpleFeatureCollection collection = this.createTightUTurnLineCollection2();
        Style style = this.loadStyle("LineStyleLarge2.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(map);
        double boundary = 2.0;
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - boundary, env.getMaxX() + boundary, env.getMinY() - boundary, env.getMaxY() + boundary, null);
        BufferedImage image = RendererBaseTest.showRender("U turn label", (GTRenderer)renderer, 1100L, env);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelSharpTurn2.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1100);
    }

    @Test
    public void testSharpChangeLastSegment() throws Exception {
        SimpleFeatureCollection collection = this.createSharpTurnLineCollection();
        Style style = this.loadStyle("LineStyleLarge.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(map);
        int boundary = 2;
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        BufferedImage image = RendererBaseTest.showRender("Ell label", (GTRenderer)renderer, 1000L, env);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelSharpTurnLastSegment.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)100);
    }

    private SimpleFeatureCollection createLineFeatureCollection() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createLineFeature("LongLabel1", (CoordinateReferenceSystem)crs, geomFac, 10.0, 0.0, 0.0, 10.0));
        data.addFeature(this.createLineFeature("LongLabel2", (CoordinateReferenceSystem)crs, geomFac, 10.0, 10.0, 0.0, 0.0));
        return data.getFeatureSource("linefeature").getFeatures();
    }

    private SimpleFeatureCollection createTightUTurnLineCollection() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createLineFeature("TheUTurnLabel", (CoordinateReferenceSystem)crs, geomFac, 1.0, 2.0, 8.7, 2.0, 9.0, 2.1, 8.7, 2.2, 1.0, 2.2));
        return data.getFeatureSource("linefeature").getFeatures();
    }

    private SimpleFeatureCollection createSharpTurnLineCollection() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createLineFeature("TheUTurnLabel", (CoordinateReferenceSystem)crs, geomFac, 1.0, 1.0, 2.0, 5.0, 3.0, 7.0, 10.0, 7.0));
        return data.getFeatureSource("linefeature").getFeatures();
    }

    private SimpleFeatureCollection createTightUTurnLineCollection2() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createLineFeature("TheUTurnLabel", (CoordinateReferenceSystem)crs, geomFac, 1.0, 2.0, 9.0, 2.0, 7.0, 2.2));
        return data.getFeatureSource("linefeature").getFeatures();
    }

    private SimpleFeature createLineFeature(String name, CoordinateReferenceSystem crs, GeometryFactory geomFac, double ... ordinates) throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(ordinates);
        LineString line = geomFac.createLineString((CoordinateSequence)cs);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("line", line.getClass(), crs);
        } else {
            builder.add("centre", line.getClass());
        }
        builder.add("name", String.class);
        builder.setName("linefeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{line, name}, null);
    }

    @Test
    public void testPolyLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createPolyFeatureCollection();
        Style style = this.loadStyle("PolyStyle.sld");
        Assert.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testPolyLabeling", (GTRenderer)renderer, this.timout, env);
    }

    private SimpleFeatureCollection createPolyFeatureCollection() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createPolyFeature(135, 40, 140, 50, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac));
        data.addFeature(this.createPolyFeature(130, 40, 140, 50, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac));
        return data.getFeatureSource("polygonfeature").getFeatures();
    }

    private SimpleFeature createPolyFeature(int startx, int starty, int width, int height, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac) throws Exception {
        Coordinate[] c = new Coordinate[]{new Coordinate((double)startx, (double)starty), new Coordinate((double)(startx + width), (double)starty), new Coordinate((double)(startx + width), (double)(starty + height)), new Coordinate((double)startx, (double)starty)};
        LinearRing line = geomFac.createLinearRing(c);
        Polygon poly = geomFac.createPolygon(line, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("polygon", poly.getClass(), crs);
        } else {
            builder.add("centre", line.getClass());
        }
        builder.add("name", String.class);
        builder.setName("polygonfeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{poly, name}, null);
    }
}

