/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.style.Style;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;

public class LabelObstacleTest {
    static MemoryDataStore mem;

    @BeforeClass
    public static void setUpData() throws Exception {
        mem = new MemoryDataStore();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("roads");
        tb.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        tb.add("geom", LineString.class);
        tb.add("name", String.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("points");
        tb.add("geom", Point.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("lines");
        tb.add("geom", LineString.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("polys");
        tb.add("geom", Polygon.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("lines2");
        tb.add("geom", MultiLineString.class);
        tb.add("name", String.class);
        mem.createSchema(tb.buildFeatureType());
        LabelObstacleTest.loadData(mem, "roads");
        LabelObstacleTest.loadData(mem, "points");
        LabelObstacleTest.loadData(mem, "lines");
        LabelObstacleTest.loadData(mem, "polys");
        LabelObstacleTest.loadData(mem, "lines2");
        RendererBaseTest.setupVeraFonts();
    }

    static void loadData(MemoryDataStore mem, String name) throws Exception {
        WKTReader wkt = new WKTReader();
        try (FeatureWriter w = mem.getFeatureWriter(name, Transaction.AUTO_COMMIT);
             BufferedReader r = new BufferedReader(new InputStreamReader(LabelObstacleTest.class.getResourceAsStream("test-data/obstacles/" + name + ".txt")));){
            String line = null;
            while ((line = r.readLine()) != null) {
                String[] values = line.split(";");
                SimpleFeature f = (SimpleFeature)w.next();
                for (int i = 0; i < f.getAttributeCount(); ++i) {
                    AttributeDescriptor ad = f.getType().getDescriptor(i);
                    if (ad instanceof GeometryDescriptor) {
                        f.setAttribute(i, (Object)wkt.read(values[i]));
                        continue;
                    }
                    f.setAttribute(i, (Object)values[i]);
                }
                w.write();
            }
        }
    }

    Style style(String name) throws Exception {
        SLDParser p = new SLDParser(CommonFactoryFinder.getStyleFactory(null), this.getClass().getResourceAsStream("test-data/obstacles/" + name + ".sld"));
        return p.readXML()[0];
    }

    Style[] styles(String ... names) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (String name : names) {
            styles.add(name != null ? this.style(name) : null);
        }
        return styles.toArray(new Style[styles.size()]);
    }

    FeatureSource[] sources(String ... names) throws Exception {
        ArrayList<ContentFeatureSource> sources = new ArrayList<ContentFeatureSource>();
        for (String name : names) {
            sources.add(mem.getFeatureSource(name));
        }
        return sources.toArray(new FeatureSource[sources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage render(FeatureSource[] sources, Style[] styles) throws Exception {
        int i;
        MapContent map = new MapContent();
        ReferencedEnvelope env = sources[0].getBounds();
        for (i = 1; i < sources.length; ++i) {
            env.expandToInclude((Envelope)sources[i].getBounds());
        }
        map.getViewport().setBounds(env);
        for (i = 0; i < sources.length; ++i) {
            if (styles[i] == null) continue;
            map.addLayer((Layer)new FeatureLayer(sources[i], styles[i]));
        }
        try {
            StreamingRenderer r = new StreamingRenderer();
            r.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            r.setMapContent(map);
            BufferedImage bufferedImage = RendererBaseTest.showRender("testPointLabeling", (GTRenderer)r, 5000L, env);
            return bufferedImage;
        }
        finally {
            map.dispose();
        }
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/obstacles/" + name + ".png");
    }

    @Test
    public void testExternalGraphicNoObstacle() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "grinNoObstacle"));
        BufferedImage points = this.render(this.sources("roads", "points"), this.styles(null, "grinNoObstacle"));
        ImageWorker extrema = this.intersectionExtrema(labels, points);
        double[] minimum = extrema.getMinimums();
        Assert.assertEquals((double)0.0, (double)minimum[0], (double)1.0);
    }

    @Test
    public void testExternalGraphic() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "grin"));
        BufferedImage points = this.render(this.sources("roads", "points"), this.styles(null, "grin"));
        this.checkNoIntersection(labels, points);
    }

    @Test
    public void testMark() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "mark"));
        BufferedImage marks = this.render(this.sources("roads", "points"), this.styles(null, "mark"));
        this.checkNoIntersection(labels, marks);
    }

    @Test
    public void testPolygon() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "polys"), this.styles("label", "poly"));
        BufferedImage polys = this.render(this.sources("roads", "polys"), this.styles(null, "poly"));
        this.checkNoIntersection(labels, polys);
    }

    @Test
    public void testLine() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "lines"), this.styles("label", "line"));
        BufferedImage roads = this.render(this.sources("roads", "lines"), this.styles(null, "line"));
        this.checkNoIntersection(labels, roads);
    }

    @Test
    public void testLineWithGraphicStroke() throws Exception {
        BufferedImage img = this.render(this.sources("lines2"), this.styles("hatch"));
        ImageAssert.assertEquals((File)this.file("hatch"), (RenderedImage)img, (int)10);
    }

    private void checkNoIntersection(BufferedImage labels, BufferedImage obstacle) {
        ImageWorker extrema = this.intersectionExtrema(labels, obstacle);
        double[] minimum = extrema.getMinimums();
        Assert.assertEquals((double)1.0, (double)minimum[0], (double)0.0);
    }

    ImageWorker intersectionExtrema(BufferedImage labels, BufferedImage obstacles) {
        ImageWorker w = new ImageWorker((RenderedImage)labels);
        ImageWorker w1 = new ImageWorker((RenderedImage)obstacles);
        w.bandCombine((double[][])new double[][]{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.0, 0.0}});
        w1.bandCombine((double[][])new double[][]{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.0, 0.0}});
        w.binarize(1.0).getRenderedImage();
        RenderedImage binaryObstacles = w1.binarize(250.0).getRenderedImage();
        w.or(binaryObstacles);
        w.getMinimums();
        return w;
    }
}

