/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class LabelDisplacementModeTest {
    private static final long TIME = 5000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource fs2;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.setName("labelDisplacement");
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.2)), "labelA"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "labelA1"}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 2.0)), "labelB"}, null);
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 3.0)), "labelB1"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f4);
        data.addFeature(f3);
        data.addFeature(f2);
        data.addFeature(f1);
        this.fs = data.getFeatureSource("labelDisplacement");
        SimpleFeatureTypeBuilder builder2 = new SimpleFeatureTypeBuilder();
        builder2.add("geom", Polygon.class);
        builder2.add("label", String.class);
        builder2.setName("labelPolyDisplacement");
        SimpleFeatureType type2 = builder2.buildFeatureType();
        SimpleFeature f11 = SimpleFeatureBuilder.build((SimpleFeatureType)type2, (Object[])new Object[]{gf.createPolygon(new Coordinate[]{new Coordinate(4.0, 7.0), new Coordinate(4.0, 9.0), new Coordinate(6.0, 9.0), new Coordinate(6.0, 7.0), new Coordinate(4.0, 7.0)}), "labelPolyA"}, null);
        MemoryDataStore data2 = new MemoryDataStore();
        data2.addFeature(f11);
        this.fs2 = data2.getFeatureSource("labelPolyDisplacement");
    }

    @Test
    public void testDisplacementStandard() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementStandard.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Default Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementStandard.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementNorth() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementN.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label North Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementN.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementSouth() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementS.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label South Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementS.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementEast() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementE.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label East Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementE.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementWest() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementW.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label West Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementW.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementNE() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementNE.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label NE Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementNE.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementNW() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementNW.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label NW Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementNW.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementSE() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementSE.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label SE Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementSE.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementSW() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementSW.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label SW Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementSW.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementDiagonal() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementDiagonal.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Diagonal Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementDiagonal.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementNotDiagonal() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementNotDiagonal.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Not Diagonal Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementNotDiagonal.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementE_NE() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementE_NE.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label E or NE Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementE_NE.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementRandomConflictDisabled() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementRandom_conflict_disabled.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Random Displacement (conflict_disabled)");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementRandom_conflict_disabled.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementStandardMultiLayer() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementStandard.sld");
        Style style2 = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementStandardPoly.sld");
        BufferedImage image = this.renderLabels(new SimpleFeatureSource[]{this.fs, this.fs2}, new Style[]{style, style2}, "Label Default Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementStandard_multi.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1600);
    }

    @Test
    public void testDisplacementNotDiagonalMultiLayer() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementNotDiagonal.sld");
        Style style2 = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementNotDiagonalPoly.sld");
        BufferedImage image = this.renderLabels(new SimpleFeatureSource[]{this.fs, this.fs2}, new Style[]{style, style2}, "Label Not Diagonal Displacement (multi)");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementNotDiagonal_multi.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1100);
    }

    @Test
    public void testDisplacementVerticalBoth() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBoth.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Vertical Both Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementVerticalBoth.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementVerticalBothMultiLayer() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBoth.sld");
        Style style2 = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBothPoly.sld");
        BufferedImage image = this.renderLabels(new SimpleFeatureSource[]{this.fs, this.fs2}, new Style[]{style, style2}, "Label Vertical Both Displacement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementVerticalBoth_multi.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1100);
    }

    @Test
    public void testDisplacementVerticalBothConflictDisabled() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBoth_conflict_disabled.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label Vertical Both Displacement (conflict_disabled)");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementVerticalBoth_conflict_disabled.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testDisplacementVerticalBothConflictDisabledMultiLayer() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBoth_conflict_disabled.sld");
        Style style2 = RendererBaseTest.loadStyle(this, "displacementMode/textDisplacementVerticalBoth_conflict_disabledPoly.sld");
        BufferedImage image = this.renderLabels(new SimpleFeatureSource[]{this.fs, this.fs2}, new Style[]{style, style2}, "Label Vertical Both Displacement (conflict_disabled)");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/textDisplacementVerticalBoth_conflict_disabled_multi.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1300);
    }

    @Test
    public void testMultiLineLabelDisplacementY() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("the_geom", LineString.class);
        builder.add("TEXTSTRING", String.class);
        builder.add("FONTNAME", String.class);
        builder.add("FONTSIZE", Integer.class);
        builder.add("FONTSTYLE", String.class);
        builder.add("ANGLE", Integer.class);
        builder.add("ANCHORY", Integer.class);
        builder.setName("geos8975");
        SimpleFeatureType type = builder.buildFeatureType();
        SimpleFeature f11 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createLineString(new Coordinate[]{new Coordinate(2.0, 5.0), new Coordinate(3.0, 5.0), new Coordinate(4.0, 5.0), new Coordinate(5.0, 5.0), new Coordinate(6.0, 5.0), new Coordinate(7.0, 5.0), new Coordinate(8.0, 5.0)}), "Espace\nPierrey\nBetazg", "Bitstream Vera Sans", 10, "Bold", 0, 0}, null);
        SimpleFeature f12 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createLineString(new Coordinate[]{new Coordinate(2.0, 3.0), new Coordinate(3.0, 3.0), new Coordinate(4.0, 3.0), new Coordinate(5.0, 3.0), new Coordinate(6.0, 3.0), new Coordinate(7.0, 3.0), new Coordinate(8.0, 3.0)}), "Liney 1\nLineg", "Bitstream Vera Sans", 10, "Bold", 0, 1}, null);
        Style style = RendererBaseTest.loadStyle(this, "displacementMode/testMultiLineLabelDisplacementY.sld");
        Assert.assertNotNull((Object)style);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f11);
        data.addFeature(f12);
        ContentFeatureSource fs3 = data.getFeatureSource("geos8975");
        BufferedImage image = this.renderLabels((SimpleFeatureSource)fs3, style, "GEOS-8975, Multi Line Label Placement");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/displacementMode/testMultiLineLabelDisplacementY.png";
        int tolerance = 2000;
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)tolerance);
    }

    private BufferedImage renderLabels(SimpleFeatureSource fs, Style style, String title) throws Exception {
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        return RendererBaseTest.showRender(title, (GTRenderer)renderer, 5000L, this.bounds);
    }

    private BufferedImage renderLabels(SimpleFeatureSource[] fs, Style[] style, String title) throws Exception {
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        for (int i = 0; i < fs.length; ++i) {
            mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs[i], style[i]));
        }
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        return RendererBaseTest.showRender(title, (GTRenderer)renderer, 5000L, this.bounds);
    }
}

