/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLD;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;

public class GeometryTransformationTest {
    private static final long TIME = 2000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;
    ReferencedEnvelope bbounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"line.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("line");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(3.0, 3.0);
        this.bfs = ds.getFeatureSource("buildings");
        this.bbounds = this.bfs.getBounds();
        this.bbounds.expandBy(3.0, 3.0);
    }

    @Test
    public void testBufferLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineBuffer.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RendererBaseTest.showRender("lineBuffer.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testBufferPoly() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "polyBuffer.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RendererBaseTest.showRender("polyBuffer.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testVertices() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineVertices.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RendererBaseTest.showRender("lineVertices.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testStartEnd() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineStartEnd.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RendererBaseTest.showRender("lineStartEnd.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testIsometric() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "isometric.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("lineStartEnd.sld", (GTRenderer)renderer, 2000L, this.bbounds);
    }

    @Test
    public void testOutOfThinAir() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("points");
        typeBuilder.add("wkt", String.class);
        typeBuilder.add("label", String.class);
        SimpleFeatureType TYPE = typeBuilder.buildFeatureType();
        ListFeatureCollection features = new ListFeatureCollection(TYPE);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(TYPE);
        for (int i = 0; i < 10; ++i) {
            fb.add((Object)("POINT(" + i + " " + i + ")"));
            fb.add((Object)("this is " + i));
            features.add(fb.buildFeature(null));
        }
        Style style = SLD.createPointStyle((String)"circle", (Color)Color.BLUE, (Color)Color.BLUE, (float)1.0f, (float)10.0f);
        PointSymbolizer ps = (PointSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        ps.setGeometry((Expression)ff.function("convert", new Expression[]{ff.property("wkt"), ff.literal(Point.class)}));
        MapContent map = new MapContent();
        FeatureLayer layer = new FeatureLayer((FeatureCollection)features, style);
        map.addLayer((Layer)layer);
        BufferedImage bi = new BufferedImage(100, 100, 5);
        StreamingRenderer renderer = new StreamingRenderer();
        Graphics2D graphics = bi.createGraphics();
        renderer.setMapContent(map);
        renderer.paint(graphics, new Rectangle(100, 100), new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null));
        graphics.dispose();
        map.dispose();
        int[] pixel = new int[3];
        for (int i = 0; i < 100; i += 10) {
            bi.getData().getPixel(i, 99 - i, pixel);
            Assert.assertEquals((long)0L, (long)pixel[0]);
            Assert.assertEquals((long)0L, (long)pixel[1]);
            Assert.assertEquals((long)255L, (long)pixel[2]);
        }
    }
}

