/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class GeographicTransformPointTest {
    private static final long TIME = 4000L;
    SimpleFeatureSource point_test;
    SimpleFeatureSource point_test_strict;
    SimpleFeatureSource point_test_2d;

    @BeforeClass
    public static void cleanupCRS() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        CRS.reset((String)"all");
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"point_test.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.point_test = ds.getFeatureSource("point_test");
        Assert.assertNotNull((String)"point_test data available", (Object)this.point_test);
        this.point_test_strict = ds.getFeatureSource("point_test_strict");
        Assert.assertNotNull((String)"point_test_strict data available", (Object)this.point_test_strict);
        this.point_test_2d = ds.getFeatureSource("point_test_2d");
        Assert.assertNotNull((String)"point_test_2d data available", (Object)this.point_test_2d);
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/line/" + name + ".png");
    }

    @Test
    public void testBounds() throws Exception {
        ReferencedEnvelope bounds2d = this.point_test_2d.getBounds();
        ReferencedEnvelope bounds3d = this.point_test.getBounds();
        double aspect2d = bounds2d.getWidth() / bounds2d.getHeight();
        double aspect3d = bounds3d.getWidth() / bounds3d.getHeight();
        Assert.assertEquals((double)aspect2d, (double)aspect3d, (double)5.0E-4);
        ReferencedEnvelope bbox2d = JTS.toGeographic((ReferencedEnvelope)bounds2d);
        ReferencedEnvelope bbox3d = JTS.toGeographic((ReferencedEnvelope)bounds3d);
        aspect2d = bbox2d.getWidth() / bbox2d.getHeight();
        aspect3d = bbox3d.getWidth() / bbox3d.getHeight();
        Assert.assertEquals((double)aspect2d, (double)aspect3d, (double)5.0E-6);
    }

    @Test
    public void testToGeographicGeometry() throws Exception {
        CoordinateReferenceSystem gda94 = CRS.decode((String)"EPSG:4939", (boolean)true);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(130.882672103999, -16.4463909341494, 97.009018073082));
        Point world = (Point)JTS.toGeographic((Geometry)point, (CoordinateReferenceSystem)gda94);
        Assert.assertEquals((double)point.getX(), (double)world.getX(), (double)5.0E-8);
        Assert.assertEquals((double)point.getY(), (double)world.getY(), (double)5.0E-8);
    }

    @Test
    public void testGDA94Points() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "markCircle.sld");
        BufferedImage reference = this.toImage(this.point_test_2d, style);
        BufferedImage actual = null;
        if (CRS.getAxisOrder((CoordinateReferenceSystem)((SimpleFeatureType)this.point_test_strict.getSchema()).getCoordinateReferenceSystem()) == CRS.AxisOrder.NORTH_EAST) {
            actual = this.toImage(this.point_test_strict, style);
        }
        if (CRS.getAxisOrder((CoordinateReferenceSystem)((SimpleFeatureType)this.point_test.getSchema()).getCoordinateReferenceSystem()) == CRS.AxisOrder.EAST_NORTH) {
            actual = this.toImage(this.point_test, style);
        }
        ImageAssert.assertEquals((RenderedImage)reference, (RenderedImage)actual, (int)10);
    }

    private BufferedImage toImage(SimpleFeatureSource featuerSource, Style style) throws Exception {
        String typeName = ((SimpleFeatureType)featuerSource.getSchema()).getTypeName();
        MapContent content = new MapContent();
        ReferencedEnvelope dataBounds = featuerSource.getBounds();
        Assert.assertNotNull((String)(typeName + " bounds"), (Object)dataBounds);
        Assert.assertFalse((String)(typeName + " bounds empty"), (boolean)dataBounds.isEmpty());
        Assert.assertFalse((String)(typeName + " bounds null"), (boolean)dataBounds.isNull());
        ReferencedEnvelope bounds = JTS.toGeographic((ReferencedEnvelope)dataBounds);
        Assert.assertNotNull((String)(typeName + " world"), (Object)bounds);
        Assert.assertTrue((String)(typeName + " world WGS84"), (boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)bounds.getCoordinateReferenceSystem()));
        Assert.assertFalse((String)(typeName + " world empty"), (boolean)bounds.isEmpty());
        Assert.assertFalse((String)(typeName + " world null"), (boolean)bounds.isNull());
        ReferencedEnvelope reference = JTS.toGeographic((ReferencedEnvelope)this.point_test_2d.getBounds());
        Assert.assertNotNull((String)"reference point_test_2d bounds", (Object)reference);
        Assert.assertTrue((String)"reference point_test_2d bounds available", (!reference.isEmpty() && !reference.isNull() ? 1 : 0) != 0);
        Assert.assertTrue((String)"bounds WGS84", (boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)reference.getCoordinateReferenceSystem()));
        content.getViewport().setBounds(reference);
        Assert.assertEquals((String)"map viewport set", (Object)reference, (Object)content.getViewport().getBounds());
        Assert.assertTrue((String)"map viewport WGS84", (boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)content.getCoordinateReferenceSystem()));
        content.addLayer((Layer)new FeatureLayer((FeatureSource)featuerSource, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender(typeName, (GTRenderer)renderer, 4000L, bounds);
        Assert.assertNotNull((Object)image);
        return image;
    }
}

