/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.DataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.FilterMemoizer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FilterMemoizerTest
extends DataTestCase {
    static FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testMemoizeFilter() throws Exception {
        SimpleFeature rf0 = (SimpleFeature)Mockito.spy((Object)this.roadFeatures[0]);
        SimpleFeature rf1 = (SimpleFeature)Mockito.spy((Object)this.roadFeatures[1]);
        PropertyIsEqualTo nameR1 = FF.equal((Expression)FF.property("name"), (Expression)FF.literal((Object)"r1"), false);
        Filter memoized = FilterMemoizer.memoize((Filter)nameR1);
        Assert.assertTrue((boolean)memoized.evaluate((Object)rf0));
        Assert.assertTrue((boolean)memoized.evaluate((Object)rf0));
        ((SimpleFeature)Mockito.verify((Object)rf0, (VerificationMode)Mockito.times((int)1))).getAttribute("name");
        Assert.assertFalse((boolean)memoized.evaluate((Object)rf1));
        ((SimpleFeature)Mockito.verify((Object)rf1, (VerificationMode)Mockito.times((int)1))).getAttribute("name");
        Assert.assertTrue((boolean)memoized.evaluate((Object)rf0));
        ((SimpleFeature)Mockito.verify((Object)rf0, (VerificationMode)Mockito.times((int)2))).getAttribute("name");
    }

    @Test
    public void testVolatileFunction() throws Exception {
        Function random = FF.function("random", new Expression[0]);
        Function spy = (Function)Mockito.spy((Object)random);
        PropertyIsGreaterThanOrEqualTo filter = FF.greaterOrEqual((Expression)spy, (Expression)FF.literal(0));
        Filter memoized = FilterMemoizer.memoize((Filter)filter);
        Assert.assertTrue((boolean)memoized.evaluate(null));
        Assert.assertTrue((boolean)memoized.evaluate(null));
        ((Function)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)2))).evaluate(null);
    }
}

