/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.SLD;
import org.geotools.styling.StrokeImpl;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class FillTest {
    private static final long TIME = 40000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bfs = ds.getFeatureSource("bigsquare");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.2, 0.2);
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    private void runSingleLayerTest(String styleName) throws Exception {
        this.runSingleLayerTest(styleName, 100);
    }

    private void runSingleLayerTest(String styleName, int threshold) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender(styleName, (GTRenderer)renderer, 40000L, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/" + styleName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)threshold);
    }

    @Test
    public void testSolidFill() throws Exception {
        this.runSingleLayerTest("fillSolid.sld");
    }

    @Test
    public void testSolidFillBackgroundSolid() throws Exception {
        this.runSingleLayerTest("fillSolidBackgroundSolid.sld");
    }

    @Test
    public void testSolidFillBackgroundMark() throws Exception {
        this.runSingleLayerTest("fillSolidBackgroundMark.sld");
    }

    @Test
    public void testCrossFill() throws Exception {
        this.runSingleLayerTest("fillCross.sld", 250);
    }

    @Test
    public void testCrossFillZoomedOut() throws Exception {
        String styleName = "fillCrossUom.sld";
        Style style = RendererBaseTest.loadStyle(this, styleName);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage bi = new BufferedImage(10, 10, 6);
        Graphics2D graphics = bi.createGraphics();
        renderer.paint(graphics, new Rectangle(0, 0, 10, 10), this.bounds);
        graphics.dispose();
        mc.dispose();
    }

    @Test
    public void testTriangleFill() throws Exception {
        this.runSingleLayerTest("fillTriangle.sld", 250);
    }

    @Test
    public void testCircleFill() throws Exception {
        this.runSingleLayerTest("fillCircle.sld");
    }

    @Test
    public void testSlash() throws Exception {
        this.runSingleLayerTest("fillSlash.sld");
    }

    @Test
    public void testImageFill() throws Exception {
        this.runSingleLayerTest("fillImage.sld");
    }

    @Test
    public void testMarkFillRotated() throws Exception {
        this.runSingleLayerTest("fillMarkRotated.sld");
    }

    @Test
    public void testFontFill() throws Exception {
        this.runSingleLayerTest("fillTTFDecorative.sld");
    }

    @Test
    public void testRandomSlash() throws Exception {
        this.runSingleLayerTest("fillRandomSlash.sld");
    }

    @Test
    public void testRandomRotatedSlash() throws Exception {
        this.runSingleLayerTest("fillRandomRotatedSlash.sld");
    }

    @Test
    public void testFillRandomGraphic() throws Exception {
        this.runSingleLayerTest("fillRandomGraphic.sld");
    }

    @Test
    public void testFillRandomRotatedGraphic() throws Exception {
        this.runSingleLayerTest("fillRandomRotatedGraphic.sld");
    }

    @Test
    public void testFillRandomTwoMarks() throws Exception {
        this.runSingleLayerTest("fillRandomTwoMarks.sld");
    }

    @Test
    public void testFillRandomGridSlash() throws Exception {
        this.runSingleLayerTest("fillRandomGridSlash.sld");
    }

    @Test
    public void testFillRandomGridGraphic() throws Exception {
        this.runSingleLayerTest("fillRandomGridGraphic.sld");
    }

    @Test
    public void testFillRandomGridRotatedSlash() throws Exception {
        this.runSingleLayerTest("fillRandomGridRotatedSlash.sld");
    }

    @Test
    public void testFillRandomGridRotatedGraphic() throws Exception {
        this.runSingleLayerTest("fillRandomGridRotatedGraphic.sld");
    }

    @Test
    public void testFTSComposition() throws Exception {
        Style bgStyle = RendererBaseTest.loadStyle(this, "fillSolid.sld");
        Style fgStyle = RendererBaseTest.loadStyle(this, "fillSolidFTS.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, bgStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, fgStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        RendererBaseTest.showRender("FTS composition", (GTRenderer)renderer, 40000L, this.bounds);
    }

    @Test
    public void testGEOT3111() throws Exception {
        FilterFactory ff2 = CommonFactoryFinder.getFilterFactory(null);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        PolygonSymbolizer sym = sf.createPolygonSymbolizer(StrokeImpl.NULL, sf.createFill((Expression)ff2.literal((Object)Color.CYAN)), null);
        Style style = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("GEOT-3111", (GTRenderer)renderer, 40000L, this.bounds);
    }
}

