/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FeatureListenerTest {
    SimpleFeatureSource squareFS;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.squareFS = ds.getFeatureSource("square");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    @Test
    public void testTwoRulesCatchAll() throws Exception {
        this.testFeatureCount("fillSolidTwoRules.sld", 2);
    }

    @Test
    public void testTwoRulesElseCatchAll() throws Exception {
        this.testFeatureCount("fillSolidTwoRuleElse.sld", 2);
    }

    protected void testFeatureCount(String sldFilename, int expectedCount) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, sldFilename);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.squareFS, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        final AtomicInteger count = new AtomicInteger();
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                count.incrementAndGet();
            }

            public void errorOccurred(Exception e) {
            }
        });
        RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds, null);
        mc.dispose();
        Assert.assertEquals((long)expectedCount, (long)count.get());
    }
}

