/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExternalGraphicTest {
    private static final long TIME = 3000L;
    SimpleFeatureSource pointFS;
    SimpleFeatureSource lineFS;
    ReferencedEnvelope bounds;

    @BeforeClass
    public static void setupClass() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.pointFS = ds.getFeatureSource("point");
        this.lineFS = ds.getFeatureSource("line");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326"));
    }

    private StreamingRenderer setupMap(String styleFile) throws IOException {
        Style gStyle = RendererBaseTest.loadStyle(this, styleFile);
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, gStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        return renderer;
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/graphic/" + name + ".png");
    }

    @Test
    public void testExternalGraphic() throws Exception {
        StreamingRenderer renderer = this.setupMap("externalGraphic.sld");
        BufferedImage image = RendererBaseTest.showRender("External graphic", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("externalGraphic"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testExternalGraphicAnchor() throws Exception {
        StreamingRenderer renderer = this.setupMap("externalGraphicAnchor.sld");
        BufferedImage image = RendererBaseTest.showRender("External graphic anchor", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("externalGraphicAnchor"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testExternalGraphicDisplacement() throws Exception {
        StreamingRenderer renderer = this.setupMap("externalGraphicDisplacement.sld");
        BufferedImage image = RendererBaseTest.showRender("External graphic displacement", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("externalGraphicDisplacement"), (RenderedImage)image, (int)50);
    }
}

